/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.blocks.tileEntity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.gekox.gekosLasers.blocks.tileEntity.TileEntityGL;
import com.gekox.gekosLasers.entity.projectile.laser.ProjectileLaser;
import com.gekox.gekosLasers.entity.projectile.laser.ProjectileLaserRed;
import com.gekox.gekosLasers.items.ItemLaserGun;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRelay
extends TileEntityGL
implements IEnergyHandler,
IInventory {
    private ItemLaserGun laserThing;
    private int storageAmount = 100000;
    public EnergyStorage storage = new EnergyStorage(this.storageAmount);
    private int energySentPerShot = this.storageAmount / 10;
    protected ItemStack[] inventory = new ItemStack[1];
    private int updateFrequency = 2;
    private int currentUpdate = 0;
    private final String TAG_MAX_ENERGY = "maxEnergy";
    private final String TAG_STORED_ENERGY = "storedEnergy";
    private final String TAG_MAX_IO = "maxIO";
    private final String TAG_INVENTORY = "inventory";
    private final String TAG_COOLDOWN = "cooldown";

    public TileEntityRelay() {
        this.storage.setMaxTransfer(this.storageAmount);
        this.storage.setMaxExtract(this.energySentPerShot);
    }

    public boolean isGettingRedstoneSignal() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.currentUpdate;
        if (this.currentUpdate == this.updateFrequency) {
            this.currentUpdate = 0;
            if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                return;
            }
            if (this.inventory[0] != null) {
                this.shoot(this.createNewLaser());
            }
            if (this.getEnergyStored() > this.energySentPerShot) {
                this.shoot(this.createNewLaser());
            }
        }
    }

    private ProjectileLaser createNewLaser() {
        ProjectileLaserRed laser = new ProjectileLaserRed(this.field_145850_b);
        laser.numOfThingsBroken = 4;
        laser.blockBreakRadius = 0;
        if (this.inventory[0] != null && laser.getAttachedItemStack() == null) {
            laser.attachItemStack(this.inventory[0]);
            this.inventory[0] = null;
        }
        if (this.getEnergyStored() > 0 && laser.getAttachedPower() <= this.energySentPerShot) {
            laser.attachPower(this.energySentPerShot);
            this.extractEnergy(this.orientation.getOpposite(), this.energySentPerShot, false);
        }
        return laser;
    }

    public void shoot(ProjectileLaser laser) {
        laser.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        switch (this.orientation) {
            case DOWN: {
                laser.func_70186_c(0.0, this.field_145848_d - 1, 0.0, -1.0f, 0.0f);
                laser.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.5, (double)this.field_145849_e + 0.5);
                break;
            }
            case UP: {
                laser.func_70186_c(0.0, this.field_145848_d + 1, 0.0, 1.0f, 0.0f);
                break;
            }
            case NORTH: {
                laser.func_70186_c(0.0, 0.0, this.field_145849_e - 1, -1.0f, 0.0f);
                break;
            }
            case SOUTH: {
                laser.func_70186_c(0.0, 0.0, this.field_145849_e + 1, 1.0f, 0.0f);
                break;
            }
            case WEST: {
                laser.func_70186_c(this.field_145851_c - 1, 0.0, 0.0, -1.0f, 0.0f);
                break;
            }
            case EAST: {
                laser.func_70186_c(this.field_145851_c + 1, 0.0, 0.0, 1.0f, 0.0f);
                break;
            }
        }
        this.field_145850_b.func_72838_d((Entity)laser);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int getEnergyStored() {
        return this.getEnergyStored(ForgeDirection.DOWN);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(ForgeDirection.DOWN);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }
}

