/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pixlepix.auracascade.QuestManager;
import pixlepix.auracascade.data.Quest;
import pixlepix.auracascade.data.QuestData;

public class PacketSyncQuestData
implements IMessage {
    public ArrayList<Quest> completed;
    public EntityPlayer entityPlayer;

    public PacketSyncQuestData(EntityPlayer entityPlayer) {
        this.entityPlayer = entityPlayer;
        this.completed = ((QuestData)entityPlayer.getExtendedProperties((String)"ACQuest")).completedQuests;
    }

    public PacketSyncQuestData() {
    }

    public void fromBytes(ByteBuf data) {
        WorldServer world = DimensionManager.getWorld((int)data.readInt());
        if (world != null) {
            this.entityPlayer = (EntityPlayer)world.func_73045_a(data.readInt());
            int desiredSize = data.readByte();
            this.completed = new ArrayList();
            for (int i = 0; i < desiredSize; ++i) {
                this.completed.add(QuestManager.quests.get(data.readByte()));
            }
        }
    }

    public void toBytes(ByteBuf data) {
        data.writeInt(this.entityPlayer.field_70170_p.field_73011_w.field_76574_g);
        data.writeInt(this.entityPlayer.func_145782_y());
        data.writeByte(this.completed.size());
        for (Quest Quest2 : this.completed) {
            data.writeByte(Quest2.id);
        }
    }

    public static class PacketSyncQuestDataHandler
    implements IMessageHandler<PacketSyncQuestData, IMessage> {
        public IMessage onMessage(PacketSyncQuestData message, MessageContext ctx) {
            if (message.entityPlayer != null) {
                QuestData data = (QuestData)message.entityPlayer.getExtendedProperties("ACQuest");
                data.completedQuests = message.completed;
            }
            return null;
        }
    }
}

