/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.main.event;

import baubles.api.BaublesApi;
import baubles.api.IBauble;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.entity.EntityDigFairy;
import pixlepix.auracascade.block.entity.EntityFallFairy;
import pixlepix.auracascade.block.entity.EntityScareFairy;
import pixlepix.auracascade.block.tile.AuraTilePumpFall;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.IAngelsteelTool;
import pixlepix.auracascade.data.QuestData;
import pixlepix.auracascade.item.AngelsteelToolHelper;
import pixlepix.auracascade.item.ItemBlueAmulet;
import pixlepix.auracascade.item.ItemComboSword;
import pixlepix.auracascade.item.ItemExplosionRing;
import pixlepix.auracascade.item.ItemFairyRing;
import pixlepix.auracascade.item.ItemFoodAmulet;
import pixlepix.auracascade.item.ItemGreenAmulet;
import pixlepix.auracascade.item.ItemLexicon;
import pixlepix.auracascade.item.ItemOrangeAmulet;
import pixlepix.auracascade.item.ItemPurpleAmulet;
import pixlepix.auracascade.item.ItemRedAmulet;
import pixlepix.auracascade.item.ItemThiefSword;
import pixlepix.auracascade.item.ItemYellowAmulet;
import pixlepix.auracascade.main.Config;
import pixlepix.auracascade.network.PacketSyncQuestData;
import pixlepix.auracascade.registry.BlockRegistry;

public class EventHandler {
    public static final String BOOK_TAG = "HAS_RECEIVED_AURA_BOOK";
    public ArrayList<EntityScareFairy> scareFairies = new ArrayList();

    public static ItemStack getBaubleFromInv(Class<? extends IBauble> clazz, EntityPlayer player) {
        IInventory inv = BaublesApi.getBaubles((EntityPlayer)player);
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !clazz.isInstance(stack.func_77973_b())) continue;
            return stack;
        }
        return null;
    }

    @SubscribeEvent
    public void onWorldLoad(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!(player.field_70170_p.field_72995_K || !Config.giveBook || player.getEntityData().func_74764_b(BOOK_TAG) && player.getEntityData().func_74767_n(BOOK_TAG))) {
            player.getEntityData().func_74757_a(BOOK_TAG, true);
            player.field_71071_by.func_70441_a(new ItemStack(BlockRegistry.getFirstItemFromClass(ItemLexicon.class)));
        }
    }

    @SubscribeEvent
    public void constructEntity(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && event.entity.getExtendedProperties("ACQuest") == null) {
            QuestData.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        NBTTagCompound compound = new NBTTagCompound();
        event.original.getExtendedProperties("ACQuest").saveNBTData(compound);
        event.entityPlayer.getExtendedProperties("ACQuest").loadNBTData(compound);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        player.getEntityData().func_74757_a(BOOK_TAG, true);
        AuraCascade.proxy.networkWrapper.sendTo((IMessage)new PacketSyncQuestData(event.player), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayerMP && !event.entity.field_70170_p.field_72995_K) {
            AuraCascade.proxy.networkWrapper.sendTo((IMessage)new PacketSyncQuestData((EntityPlayer)event.entity), (EntityPlayerMP)event.entity);
        }
    }

    @SubscribeEvent
    public void onExplode(ExplosionEvent.Detonate event) {
        List<Block> affectedBlocks = Arrays.asList(Blocks.field_150349_c, Blocks.field_150322_A, Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150346_d, Blocks.field_150347_e, Blocks.field_150351_n);
        if (!event.world.field_72995_K) {
            Explosion explosion = event.explosion;
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)(explosion.field_77284_b - 3.0), (double)(explosion.field_77285_c - 3.0), (double)(explosion.field_77282_d - 3.0), (double)(explosion.field_77284_b + 3.0), (double)(explosion.field_77285_c + 3.0), (double)(explosion.field_77282_d + 3.0));
            List players = event.world.func_72872_a(EntityPlayer.class, axisAlignedBB);
            for (EntityPlayer player : players) {
                if (EventHandler.getBaubleFromInv(ItemExplosionRing.class, player) == null) continue;
                Iterator iterator = explosion.field_77281_g.iterator();
                while (iterator.hasNext()) {
                    ChunkPosition position = (ChunkPosition)iterator.next();
                    Block block = event.world.func_147439_a(position.field_151329_a, position.field_151327_b, position.field_151328_c);
                    if (affectedBlocks.contains(block) || block == Blocks.field_150350_a) continue;
                    iterator.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        int scareCount = 0;
        for (Entity entity : this.scareFairies) {
            if (entity.field_70170_p != event.world || !(entity.func_70011_f((double)event.x, (double)event.y, (double)event.z) < 50.0)) continue;
            ++scareCount;
        }
        Random random = new Random();
        if (scareCount > 0 && random.nextInt(25) <= scareCount) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingHurtEvent event) {
        ItemStack stack;
        if (event.entity instanceof EntityPlayer && (event.source == DamageSource.field_76371_c || event.source == DamageSource.field_76370_b || event.source == DamageSource.field_76372_a) && (stack = EventHandler.getBaubleFromInv(ItemRedAmulet.class, (EntityPlayer)event.entity)) != null) {
            if (event.source != DamageSource.field_76371_c) {
                ((EntityPlayer)event.entity).func_70691_i(event.ammount);
            }
            event.ammount = 0.0f;
        }
        if (event.source != null && event.source.func_76346_g() instanceof EntityPlayer && (stack = ((EntityPlayer)event.source.func_76346_g()).func_70694_bm()) != null && stack.func_77973_b() instanceof ItemComboSword) {
            int timeDiff;
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            if ((timeDiff = (int)Math.abs(event.entity.field_70170_p.func_82737_E() - stack.field_77990_d.func_74763_f("lastComboTime"))) < 100 && timeDiff > 4) {
                int combo = stack.field_77990_d.func_74762_e("comboCount");
                double comboMultiplier = ItemComboSword.getComboMultiplier(combo);
                event.ammount = (float)((double)event.ammount * comboMultiplier);
                if (combo < 100) {
                    stack.field_77990_d.func_74768_a("comboCount", stack.field_77990_d.func_74762_e("comboCount") + 1);
                }
            } else {
                stack.field_77990_d.func_74768_a("comboCount", 0);
            }
            stack.field_77990_d.func_74772_a("lastComboTime", event.entity.field_70170_p.func_82737_E());
        }
        if (event.entity instanceof EntityPlayer && event.source.func_94541_c() && (stack = EventHandler.getBaubleFromInv(ItemOrangeAmulet.class, (EntityPlayer)event.entity)) != null) {
            ((EntityPlayer)event.entity).func_70691_i(event.ammount);
            event.ammount = 0.0f;
        }
        if (event.entity instanceof EntityPlayer && event.source.func_76352_a() && (stack = EventHandler.getBaubleFromInv(ItemYellowAmulet.class, (EntityPlayer)event.entity)) != null) {
            event.ammount /= 2.0f;
        }
        if (event.entity instanceof EntityPlayer && event.source == DamageSource.field_76379_h && (stack = EventHandler.getBaubleFromInv(ItemGreenAmulet.class, (EntityPlayer)event.entity)) != null) {
            ((EntityPlayer)event.entity).func_70691_i(event.ammount);
            event.ammount = 0.0f;
        }
        if (event.entity instanceof EntityPlayer && event.source == DamageSource.field_76369_e && (stack = EventHandler.getBaubleFromInv(ItemBlueAmulet.class, (EntityPlayer)event.entity)) != null) {
            ((EntityPlayer)event.entity).func_70691_i(event.ammount);
            event.ammount = 0.0f;
        }
        if (event.entity instanceof EntityPlayer && event.source == DamageSource.field_82727_n && (stack = EventHandler.getBaubleFromInv(ItemPurpleAmulet.class, (EntityPlayer)event.entity)) != null) {
            event.ammount = 0.0f;
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityPlayer player;
        ItemStack swordStack;
        if (!event.entity.field_70170_p.field_72995_K && event.source.func_76364_f() instanceof EntityPlayer && (swordStack = (player = (EntityPlayer)event.source.func_76364_f()).func_71045_bC()) != null && swordStack.func_77973_b() instanceof ItemThiefSword && event.entity instanceof EntityVillager && new Random().nextInt(4) == 0) {
            EntityVillager villager = (EntityVillager)event.entity;
            ItemStack dropStack = ((MerchantRecipe)villager.func_70934_b(player).get(0)).func_77397_d();
            EntityItem entityItem = new EntityItem(player.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, dropStack);
            event.drops.add(entityItem);
        }
    }

    @SubscribeEvent
    public void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack item = BaublesApi.getBaubles((EntityPlayer)event.entityPlayer).func_70301_a(1);
        if (item != null && item.func_77973_b() instanceof ItemFairyRing && !event.entityPlayer.field_70170_p.field_72995_K) {
            List fairyList = event.entityPlayer.field_70170_p.func_72872_a(EntityDigFairy.class, event.entityPlayer.field_70121_D.func_72314_b(20.0, 20.0, 20.0));
            int count = -1;
            for (EntityDigFairy digFairy : fairyList) {
                if (digFairy.player != event.entityPlayer) continue;
                ++count;
            }
            count = Math.min(count, 15);
            event.newSpeed = (float)((double)event.newSpeed * Math.pow(1.08, count));
        }
        if (event.entityPlayer.field_71071_by.func_70448_g() != null && AngelsteelToolHelper.isAngelsteelTool(event.entityPlayer.field_71071_by.func_70448_g().func_77973_b())) {
            int[] buffs;
            ItemStack tool;
            if (event.entityPlayer.field_71071_by.func_70448_g().field_77990_d == null) {
                event.entityPlayer.field_71071_by.func_70448_g().field_77990_d = AngelsteelToolHelper.getRandomBuffCompound(((IAngelsteelTool)event.entityPlayer.field_71071_by.func_70448_g().func_77973_b()).getDegree());
            }
            if (ForgeHooks.canToolHarvestBlock((Block)event.block, (int)event.metadata, (ItemStack)(tool = event.entityPlayer.field_71071_by.func_70448_g())) && (buffs = AngelsteelToolHelper.readFromNBT(event.entityPlayer.field_71071_by.func_70448_g().field_77990_d)).length > 0) {
                int efficiency = buffs[0];
                event.newSpeed = (float)((double)event.newSpeed * Math.pow(1.3, efficiency));
                int shatter = buffs[2];
                int disintegrate = buffs[3];
                if (event.block.func_149712_f(event.entity.field_70170_p, event.x, event.y, event.z) <= 1.0f) {
                    event.newSpeed = (float)((double)event.newSpeed * Math.pow(3.0, disintegrate));
                }
                if (event.block.func_149712_f(event.entity.field_70170_p, event.x, event.y, event.z) >= 2.0f) {
                    event.newSpeed = (float)((double)event.newSpeed * Math.pow(3.0, shatter));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onHarvestEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && event.harvester.field_71071_by.func_70448_g() != null && AngelsteelToolHelper.isAngelsteelTool(event.harvester.field_71071_by.func_70448_g().func_77973_b())) {
            int fortune;
            if (event.harvester.field_71071_by.func_70448_g().field_77990_d == null) {
                event.harvester.field_71071_by.func_70448_g().field_77990_d = AngelsteelToolHelper.getRandomBuffCompound(((IAngelsteelTool)event.harvester.field_71071_by.func_70448_g().func_77973_b()).getDegree());
            }
            if (event.fortuneLevel < (fortune = AngelsteelToolHelper.readFromNBT(event.harvester.field_71071_by.func_70448_g().field_77990_d)[1]) && event.dropChance <= 0.0f && event.drops.size() > 0 && !(event.block instanceof BlockCrops)) {
                event.dropChance = 0.0f;
                event.drops.clear();
                event.block.func_149690_a(event.world, event.x, event.y, event.z, event.blockMetadata, 1.0f, fortune);
            }
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        EntityPlayer entityPlayer;
        ItemStack item;
        if (event.entityLiving instanceof EntityPlayer && (item = BaublesApi.getBaubles((EntityPlayer)(entityPlayer = (EntityPlayer)event.entityLiving)).func_70301_a(1)) != null && item.func_77973_b() instanceof ItemFairyRing && !entityPlayer.field_70170_p.field_72995_K) {
            List fairyList = entityPlayer.field_70170_p.func_72872_a(EntityFallFairy.class, entityPlayer.field_70121_D.func_72314_b(20.0, 20.0, 20.0));
            int count = 0;
            for (EntityFallFairy fairy : fairyList) {
                if (fairy.player != entityPlayer) continue;
                ++count;
            }
            event.distance = (float)((double)event.distance * Math.pow(0.5, count));
        }
        int x = (int)event.entity.field_70165_t;
        int y = (int)event.entity.field_70163_u;
        int z = (int)event.entity.field_70161_v;
        CoordTuple tuple = new CoordTuple(x, y, z);
        for (CoordTuple searchPump : tuple.inRange(3)) {
            if (!(searchPump.getTile(event.entity.field_70170_p) instanceof AuraTilePumpFall)) continue;
            ((AuraTilePumpFall)searchPump.getTile(event.entity.field_70170_p)).onFall(event);
            break;
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        EntityPlayer entityPlayer;
        ItemStack item;
        if (event.entityLiving instanceof EntityPlayer && !((EntityPlayer)event.entityLiving).field_70170_p.func_82736_K().func_82766_b("keepInventory") && (item = EventHandler.getBaubleFromInv(ItemFairyRing.class, entityPlayer = (EntityPlayer)event.entityLiving)) != null && item.func_77973_b() instanceof ItemFairyRing) {
            ItemFairyRing.killNearby((EntityLivingBase)entityPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ItemStack item = EventHandler.getBaubleFromInv(ItemFairyRing.class, event.player);
        if (item != null && item.func_77973_b() instanceof ItemFairyRing && !event.player.field_70170_p.field_72995_K) {
            ItemFairyRing.killNearby((EntityLivingBase)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ItemStack item = EventHandler.getBaubleFromInv(ItemFairyRing.class, event.player);
        if (item != null && item.func_77973_b() instanceof ItemFairyRing && !event.player.field_70170_p.field_72995_K) {
            ItemFairyRing.makeFaries(item, (EntityLivingBase)event.player);
        }
    }

    @SubscribeEvent
    public void onEatEvent(PlayerUseItemEvent.Finish finishEvent) {
        EntityPlayer player = finishEvent.entityPlayer;
        ItemStack heldStack = player.field_71071_by.func_70448_g();
        if (!(EventHandler.getBaubleFromInv(ItemFoodAmulet.class, player) == null || player.field_70170_p.field_72995_K || heldStack == null || heldStack.func_77973_b().func_77661_b(heldStack) != EnumAction.eat && heldStack.func_77973_b().func_77661_b(heldStack) != EnumAction.drink)) {
            if (heldStack.func_77973_b().func_77658_a().equals("item.apple")) {
                player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 7200, 1));
            } else {
                Potion potion;
                String name = heldStack.func_77977_a();
                Random random = new Random(name.hashCode());
                while ((potion = Potion.field_76425_a[random.nextInt(23) + 1]).func_76403_b()) {
                }
                int duration = Math.max(0, (int)(random.nextGaussian() * 20.0 * 120.0 + 4800.0));
                int amplified = random.nextInt(6);
                PotionEffect potionEffect = new PotionEffect(potion.field_76415_H, duration, amplified);
                player.func_70690_d(potionEffect);
            }
        }
    }
}

