/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.lexicon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.StatCollector;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.lexicon.LexiconCategory;
import pixlepix.auracascade.lexicon.LexiconPage;

public class LexiconEntry
implements Comparable<LexiconEntry> {
    public final String unlocalizedName;
    public final LexiconCategory category;
    public List<LexiconPage> pages = new ArrayList<LexiconPage>();
    private boolean priority = false;

    public LexiconEntry(String unlocalizedName, LexiconCategory category) {
        this.unlocalizedName = unlocalizedName;
        this.category = category;
    }

    public LexiconEntry tutorial() {
        AuraCascade.proxy.addToTutorial(this);
        return this;
    }

    public LexiconEntry setPriority() {
        this.priority = true;
        return this;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public LexiconEntry setLexiconPages(LexiconPage ... pages) {
        this.pages.addAll(Arrays.asList(pages));
        for (int i = 0; i < this.pages.size(); ++i) {
            LexiconPage page = this.pages.get(i);
            if (page.skipRegistry) continue;
            page.onPageAdded(this, i);
        }
        return this;
    }

    public void addPage(LexiconPage page) {
        this.pages.add(page);
    }

    public String getNameForSorting() {
        return (this.priority ? 0 : 1) + StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    @Override
    public int compareTo(LexiconEntry o) {
        return this.getNameForSorting().compareTo(o.getNameForSorting());
    }

    public String getSuffix() {
        return "";
    }
}

