/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.lexicon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pixlepix.auracascade.lexicon.CategoryManager;
import pixlepix.auracascade.lexicon.ClientTickHandler;
import pixlepix.auracascade.lexicon.GuiLexicon;
import pixlepix.auracascade.lexicon.GuiLexiconEntry;
import pixlepix.auracascade.lexicon.IParented;
import pixlepix.auracascade.lexicon.LexiconCategory;
import pixlepix.auracascade.lexicon.LexiconEntry;
import pixlepix.auracascade.lexicon.button.GuiButtonBack;
import pixlepix.auracascade.lexicon.button.GuiButtonInvisible;
import pixlepix.auracascade.lexicon.button.GuiButtonPage;
import pixlepix.auracascade.main.EnumColor;

public class GuiLexiconIndex
extends GuiLexicon
implements IParented {
    LexiconCategory category;
    String title;
    int page = 0;
    int tutPage = -1;
    GuiButton leftButton;
    GuiButton rightButton;
    GuiButton backButton;
    GuiLexicon parent;
    GuiTextField searchField;
    List<LexiconEntry> entriesToDisplay = new ArrayList<LexiconEntry>();
    int fx = 0;
    boolean swiped = false;

    public GuiLexiconIndex(LexiconCategory category) {
        this.category = category;
        this.title = StatCollector.func_74838_a((String)(category == null ? "auramisc.lexiconIndex" : category.getUnlocalizedName()));
        this.parent = new GuiLexicon();
    }

    @Override
    void drawHeader() {
    }

    @Override
    String getTitle() {
        return this.title;
    }

    @Override
    boolean isIndex() {
        return true;
    }

    @Override
    boolean isCategoryIndex() {
        return false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.backButton = new GuiButtonBack(12, this.left + this.guiWidth / 2 - 8, this.top + this.guiHeight + 2);
        this.field_146292_n.add(this.backButton);
        this.leftButton = new GuiButtonPage(13, this.left, this.top + this.guiHeight - 10, false);
        this.field_146292_n.add(this.leftButton);
        this.rightButton = new GuiButtonPage(14, this.left + this.guiWidth - 18, this.top + this.guiHeight - 10, true);
        this.field_146292_n.add(this.rightButton);
        this.searchField = new GuiTextField(this.field_146289_q, this.left + this.guiWidth / 2 + 28, this.top + this.guiHeight + 6, 200, 10);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.searchField.func_146185_a(false);
        this.updateAll();
    }

    void updateAll() {
        this.buildEntries();
        this.updatePageButtons();
        this.populateIndex();
    }

    void buildEntries() {
        this.entriesToDisplay.clear();
        for (LexiconEntry entry : this.category == null ? CategoryManager.getAllEntries() : this.category.entries) {
            if (!StatCollector.func_74838_a((String)entry.getUnlocalizedName()).toLowerCase().contains(this.searchField.func_146179_b().toLowerCase().trim())) continue;
            this.entriesToDisplay.add(entry);
        }
        Collections.sort(this.entriesToDisplay);
    }

    @Override
    void populateIndex() {
        LexiconEntry tutEntry = tutorial != null && !tutorial.isEmpty() ? (LexiconEntry)tutorial.peek() : null;
        for (int i = this.page * 12; i < (this.page + 1) * 12; ++i) {
            LexiconEntry entry;
            GuiButtonInvisible button = (GuiButtonInvisible)((Object)this.field_146292_n.get(i - this.page * 12));
            LexiconEntry lexiconEntry = entry = i >= this.entriesToDisplay.size() ? null : this.entriesToDisplay.get(i);
            if (entry != null) {
                button.field_146126_j = (Object)((Object)EnumColor.BLACK) + "" + (entry.isPriority() ? EnumChatFormatting.ITALIC : "") + StatCollector.func_74838_a((String)entry.getUnlocalizedName()) + entry.getSuffix();
                if (entry != tutEntry) continue;
                this.tutPage = this.page;
                continue;
            }
            button.field_146126_j = "";
        }
    }

    @Override
    public void positionTutorialArrow() {
        LexiconEntry entry = (LexiconEntry)tutorial.peek();
        LexiconCategory category = entry.category;
        if (category != this.category) {
            this.orientTutorialArrowWithButton(this.backButton);
            return;
        }
        if (this.tutPage != -1 && this.tutPage != this.page) {
            this.orientTutorialArrowWithButton(this.tutPage < this.page ? this.leftButton : this.rightButton);
            return;
        }
        List buttons = this.field_146292_n;
        for (GuiButton button : buttons) {
            int id = button.field_146127_k;
            int index = id + this.page * 12;
            if (index >= this.entriesToDisplay.size() || entry != this.entriesToDisplay.get(index)) continue;
            this.orientTutorialArrowWithButton(id >= 12 ? this.rightButton : button);
            break;
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        if (!this.searchField.func_146179_b().isEmpty()) {
            this.drawBookmark(this.left + 138, this.top + this.guiHeight - 24, "  " + this.searchField.func_146179_b(), false);
            this.field_146297_k.field_71446_o.func_110577_a(texture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.left + 134, this.top + this.guiHeight - 26, 86, 180, 12, 12);
        }
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146127_k >= 1337) {
            this.handleBookmark(par1GuiButton);
        } else {
            switch (par1GuiButton.field_146127_k) {
                case 12: {
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                    ClientTickHandler.notifyPageChange();
                    break;
                }
                case 13: {
                    --this.page;
                    this.updatePageButtons();
                    this.populateIndex();
                    ClientTickHandler.notifyPageChange();
                    break;
                }
                case 14: {
                    ++this.page;
                    this.updatePageButtons();
                    this.populateIndex();
                    ClientTickHandler.notifyPageChange();
                    break;
                }
                default: {
                    int index = par1GuiButton.field_146127_k + this.page * 12;
                    this.openEntry(index);
                }
            }
        }
    }

    void openEntry(int index) {
        if (index >= this.entriesToDisplay.size()) {
            return;
        }
        LexiconEntry entry = this.entriesToDisplay.get(index);
        this.field_146297_k.func_147108_a((GuiScreen)new GuiLexiconEntry(entry, this));
        ClientTickHandler.notifyPageChange();
    }

    public void updatePageButtons() {
        this.leftButton.field_146124_l = this.page != 0;
        this.rightButton.field_146124_l = this.page < (this.entriesToDisplay.size() - 1) / 12;
        this.putTutorialArrow();
    }

    @Override
    public void setParent(GuiLexicon gui) {
        this.parent = gui;
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        if (button == 0 && Math.abs(x - this.fx) > 100 && this.field_146297_k.field_71474_y.field_85185_A && !this.swiped) {
            double swipe = (double)(x - this.fx) / Math.max(1.0, (double)time);
            if (swipe < 0.5) {
                this.nextPage();
                this.swiped = true;
            } else if (swipe > 0.5) {
                this.prevPage();
                this.swiped = true;
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.searchField.func_146192_a(par1, par2, par3);
        this.fx = par1;
        if (par3 == 1) {
            this.back();
        }
    }

    public void func_146274_d() {
        int w;
        super.func_146274_d();
        if (Mouse.getEventButton() == 0) {
            this.swiped = false;
        }
        if ((w = Mouse.getEventDWheel()) < 0) {
            this.nextPage();
        } else if (w > 0) {
            this.prevPage();
        }
    }

    @Override
    boolean closeScreenOnInvKey() {
        return false;
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        if (par2 == 203 || par2 == 200 || par2 == 201) {
            this.prevPage();
        } else if (par2 == 205 || par2 == 208 || par2 == 209) {
            this.nextPage();
        } else if (par2 == 14 && this.searchField.func_146179_b().isEmpty()) {
            this.back();
        } else if (par2 == 199) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLexicon());
            ClientTickHandler.notifyPageChange();
        } else if (par2 == 28 && this.entriesToDisplay.size() == 1) {
            this.openEntry(0);
        }
        String search = this.searchField.func_146179_b();
        this.searchField.func_146201_a(par1, par2);
        if (!this.searchField.func_146179_b().equalsIgnoreCase(search)) {
            this.updateAll();
        }
        super.func_73869_a(par1, par2);
    }

    void back() {
        if (this.backButton.field_146124_l) {
            this.func_146284_a(this.backButton);
            this.backButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }

    void nextPage() {
        if (this.rightButton.field_146124_l) {
            this.func_146284_a(this.rightButton);
            this.rightButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }

    void prevPage() {
        if (this.leftButton.field_146124_l) {
            this.func_146284_a(this.leftButton);
            this.leftButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }
}

