/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.item;

import java.util.ArrayList;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.data.recipe.ProcessorRecipe;
import pixlepix.auracascade.data.recipe.PylonRecipe;
import pixlepix.auracascade.data.recipe.PylonRecipeComponent;
import pixlepix.auracascade.registry.BlockRegistry;
import pixlepix.auracascade.registry.ITTinkererItem;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;
import pixlepix.auracascade.registry.ThaumicTinkererRecipeMulti;

public class ItemMaterial
extends Item
implements ITTinkererItem {
    public static String[] names = new String[]{"ingot", "gem", "prism"};
    public EnumAura aura;
    public int materialIndex;

    public ItemMaterial(EnumAura aura, int materialIndex) {
        this.aura = aura;
        this.materialIndex = materialIndex;
    }

    public ItemMaterial(MaterialPair materialPair) {
        this(materialPair.aura, materialPair.materialIndex);
    }

    public ItemMaterial() {
        this(EnumAura.WHITE_AURA, 2);
    }

    public static ItemMaterial getItemFromSpecs(MaterialPair pair) {
        ArrayList<Item> blockList = BlockRegistry.getItemFromClass(ItemMaterial.class);
        for (Item b : blockList) {
            ItemMaterial itemMaterial = (ItemMaterial)b;
            if (pair.aura != itemMaterial.aura || pair.materialIndex != itemMaterial.materialIndex) continue;
            return itemMaterial;
        }
        return null;
    }

    public static ItemStack getPrism() {
        return ItemMaterial.getPrism(1);
    }

    public static ItemStack getPrism(int size) {
        return new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.WHITE_AURA, 2)), size);
    }

    public static ItemStack getGem(EnumAura color, int size) {
        return new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(color, 1)), 1);
    }

    public static ItemStack getGem(EnumAura color) {
        return ItemMaterial.getGem(color, 1);
    }

    public static ItemStack getIngot(EnumAura color) {
        return ItemMaterial.getIngot(color, 1);
    }

    public static ItemStack getIngot(EnumAura color, int size) {
        return new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(color, 0)), size);
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < 2; ++i) {
            for (EnumAura auraCons : EnumAura.values()) {
                result.add(new MaterialPair(auraCons, i));
            }
        }
        return result;
    }

    @Override
    public String getItemName() {
        return names[this.materialIndex] + this.aura.name;
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("aura:" + names[this.materialIndex] + this.aura.name);
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        if (this.materialIndex == 0) {
            ThaumicTinkererRecipeMulti multi = new ThaumicTinkererRecipeMulti();
            for (int i : this.aura.dyes) {
                multi.addRecipe(new ProcessorRecipe(new ItemStack((Item)this), false, new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150325_L, 1, i)));
            }
            return multi;
        }
        if (this.materialIndex == 1) {
            return new PylonRecipe(new ItemStack((Item)this), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 60000), new ItemStack(Items.field_151045_i)), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 20000), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(this.aura, 0)))), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 20000), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(this.aura, 0)))), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 20000), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(this.aura, 0)))));
        }
        if (this.materialIndex == 2) {
            return new ProcessorRecipe(new ItemStack((Item)this), false, new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.RED_AURA, 1))), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.ORANGE_AURA, 1))), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.YELLOW_AURA, 1))), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.BLUE_AURA, 1))), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.GREEN_AURA, 1))), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.VIOLET_AURA, 1))), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.BLACK_AURA, 1))), new ItemStack((Item)ItemMaterial.getItemFromSpecs(new MaterialPair(EnumAura.WHITE_AURA, 1))));
        }
        return null;
    }

    @Override
    public int getCreativeTabPriority() {
        return 25;
    }

    public static class MaterialPair {
        private final EnumAura aura;
        private final int materialIndex;

        public MaterialPair(EnumAura aura, int materialIndex) {
            this.aura = aura;
            this.materialIndex = materialIndex;
        }
    }
}

