/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.data;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StorageItemStack {
    public Item item;
    public int stackSize;
    public int damage;
    public NBTTagCompound compound;

    public StorageItemStack(Item item, int stackSize, int damage, NBTTagCompound compound) {
        this.item = item;
        this.stackSize = stackSize;
        this.damage = damage;
        this.compound = compound;
    }

    public StorageItemStack(ItemStack stack) {
        this(stack.func_77973_b(), stack.field_77994_a, stack.func_77960_j(), stack.field_77990_d);
    }

    public static StorageItemStack readFromNBT(NBTTagCompound compound) {
        Item item = (Item)Item.field_150901_e.func_82594_a(compound.func_74779_i("item"));
        int stackSize = compound.func_74762_e("stackSize");
        int damage = compound.func_74762_e("damage");
        compound = compound.func_74775_l("compound");
        return new StorageItemStack(item, stackSize, damage, compound);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74778_a("item", Item.field_150901_e.func_148750_c((Object)this.item));
        result.func_74768_a("stackSize", this.stackSize);
        result.func_74768_a("damage", this.damage);
        result.func_74782_a("compound", (NBTBase)this.compound);
        return result;
    }

    public boolean equalsType(Object obj) {
        if (obj instanceof StorageItemStack) {
            StorageItemStack storageItemStack = (StorageItemStack)obj;
            if (storageItemStack.damage == this.damage && storageItemStack.item == this.item) {
                if (storageItemStack.compound == null) {
                    return this.compound == null;
                }
                if (storageItemStack.compound.equals((Object)this.compound)) {
                    return true;
                }
            }
        }
        return false;
    }

    public StorageItemStack copy() {
        return new StorageItemStack(this.item, this.stackSize, this.damage, this.compound != null ? (NBTTagCompound)this.compound.func_74737_b() : null);
    }

    public StorageItemStack merge(StorageItemStack other, int max) {
        if (!this.equalsType(other)) {
            return other;
        }
        StorageItemStack otherStack = other.copy();
        int delta = Math.min(max - this.stackSize, otherStack.stackSize);
        otherStack.stackSize -= delta;
        if (otherStack.stackSize <= 0) {
            otherStack = null;
        }
        this.stackSize += delta;
        return otherStack;
    }

    public ArrayList<ItemStack> getItemStacks(int maxSize) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        StorageItemStack copy = this.copy();
        for (int i = 0; i < maxSize / 64; ++i) {
            int delta = Math.min(64, copy.stackSize);
            copy.stackSize -= delta;
            ItemStack resultStack = null;
            if (delta > 0) {
                resultStack = new ItemStack(this.item, delta, this.damage);
                resultStack.field_77990_d = (NBTTagCompound)this.compound.func_74737_b();
            }
            result.add(resultStack);
        }
        return result;
    }

    public ItemStack toItemStack() {
        if (this.stackSize == 0) {
            return null;
        }
        ItemStack result = new ItemStack(this.item, this.stackSize, this.damage);
        result.field_77990_d = this.compound;
        return result;
    }
}

