/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.data;

import java.util.List;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.AuraTile;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.main.AuraUtil;
import pixlepix.auracascade.main.EnumColor;

public enum EnumAura {
    WHITE_AURA("White", 1.0, 1.0, 1.0, EnumColor.BLACK, new int[]{0}),
    GREEN_AURA("Green", 0.1, 1.0, 0.1, EnumColor.DARK_GREEN, new int[]{5, 13}){

        @Override
        public double getRelativeMass(World world) {
            AuraCascade.analytics.eventDesign("greenAura");
            if (world.func_72935_r()) {
                return 2.0;
            }
            return 0.5;
        }
    }
    ,
    BLACK_AURA("Black", 0.1, 0.1, 0.1, EnumColor.BLACK, new int[]{12, 15, 7, 8}){

        @Override
        public double getRelativeMass(World world) {
            AuraCascade.analytics.eventDesign("blackAura");
            return 0.0;
        }
    }
    ,
    RED_AURA("Red", 1.0, 0.1, 0.1, EnumColor.RED, new int[]{14}){

        @Override
        public void updateTick(World world, CoordTuple tuple, AuraQuantity quantity) {
            AxisAlignedBB search = tuple.getBoundingBox(3);
            List tntList = world.func_72872_a(EntityTNTPrimed.class, search);
            for (EntityTNTPrimed tntPrimed : tntList) {
                if (tntPrimed.field_70516_a > 2 || tntPrimed.field_70128_L) continue;
                tntPrimed.func_70106_y();
                this.explosionPushUp(world, tuple, 200000);
            }
            List creeperList = world.func_72872_a(EntityCreeper.class, search);
            for (EntityCreeper creeper : creeperList) {
                if (creeper.field_70833_d + 2 < creeper.field_82225_f || creeper.field_70128_L) continue;
                creeper.func_70106_y();
                this.explosionPushUp(world, tuple, 50000);
            }
            AuraCascade.analytics.eventDesign("redAura", AuraUtil.formatLocation(tuple));
        }
    }
    ,
    ORANGE_AURA("Orange", 1.0, 0.5, 0.0, EnumColor.ORANGE, new int[]{1}){

        @Override
        public void onTransfer(World world, CoordTuple tuple, AuraQuantity quantity, ForgeDirection direction) {
            block0: for (CoordTuple nearbyNode : tuple.inRange(2)) {
                if (!(nearbyNode.getTile(world) instanceof AuraTile) || tuple.equals(nearbyNode) || tuple.getDirectionTo(nearbyNode) == direction || tuple.getDirectionTo(nearbyNode) == direction.getOpposite()) continue;
                AuraTile auraTile = (AuraTile)nearbyNode.getTile(world);
                for (CoordTuple targetNode : auraTile.connected) {
                    if (nearbyNode.getDirectionTo(targetNode) != direction) continue;
                    ((AuraTile)nearbyNode.getTile((World)world)).inducedBurstMap.put(targetNode, quantity.getNum());
                    continue block0;
                }
            }
            AuraCascade.analytics.eventDesign("orangeAura", AuraUtil.formatLocation(tuple));
        }

        @Override
        public double getRelativeMass(World world) {
            return 0.0;
        }
    }
    ,
    YELLOW_AURA("Yellow", 1.0, 1.0, 0.1, EnumColor.YELLOW, new int[]{4}){

        @Override
        public double getAscentBoost(World world) {
            return 2.0;
        }

        @Override
        public void updateTick(World world, CoordTuple tuple, AuraQuantity quantity) {
            if (world.func_82737_E() % 1200L == 5L) {
                AuraTile tile = (AuraTile)tuple.getTile(world);
                tile.storage.set(this, (int)(0.8 * (double)tile.storage.get(this)));
                AuraCascade.analytics.eventDesign("yellowAura", AuraUtil.formatLocation(tuple), 0);
            }
        }
    }
    ,
    BLUE_AURA("Blue", 0.1, 0.1, 1.0, EnumColor.DARK_BLUE, new int[]{3, 9, 11}){

        @Override
        public double getAscentBoost(World world) {
            AuraCascade.analytics.eventDesign("blueAura");
            return world.func_72896_J() ? 4.0 : 0.5;
        }
    }
    ,
    VIOLET_AURA("Violet", 1.0, 0.1, 1.0, EnumColor.PURPLE, new int[]{2, 6, 10}){

        @Override
        public void updateTick(World world, CoordTuple tuple, AuraQuantity quantity) {
            if (quantity.getNum() > 2600) {
                AuraTile tile = (AuraTile)tuple.getTile(world);
                if (tile != null) {
                    tile.storage.set(this, 0);
                }
            } else if (world.func_82737_E() % 300L == 5L) {
                AuraTile tile = (AuraTile)tuple.getTile(world);
                int num = quantity.getNum();
                int delta = num <= 25 ? -num : 5 * Math.min(100, (int)Math.floor(2500.0 / (double)num));
                AuraCascade.analytics.eventDesign("violetAura", AuraUtil.formatLocation(tile), num);
                if (tile == null) {
                    AuraCascade.log.error("Tile entity is null in updateTick of EnumAura X: " + tuple.getX() + "Y: " + tuple.getY() + "Z: " + tuple.getZ());
                } else if (tile.storage == null) {
                    AuraCascade.log.error("Storage data is null in updateTick of EnumAura");
                } else {
                    tile.storage.set(this, num + delta);
                }
            }
        }
    };

    public String name;
    public double r;
    public double g;
    public double b;
    public EnumColor color;
    public int[] dyes;

    private EnumAura(String name, double r, double g, double b, EnumColor color, int[] dyes) {
        this.name = name;
        this.r = r;
        this.g = g;
        this.b = b;
        this.color = color;
        this.dyes = dyes;
    }

    public static EnumAura getColorFromDyeMeta(int i) {
        for (EnumAura aura : EnumAura.values()) {
            for (int dyeMeta : aura.dyes) {
                if (dyeMeta != i) continue;
                return aura;
            }
        }
        return null;
    }

    public void updateTick(World world, CoordTuple tuple, AuraQuantity quantity) {
    }

    public double getRelativeMass(World world) {
        return 1.0;
    }

    public double getAscentBoost(World world) {
        return 1.0;
    }

    public void onTransfer(World world, CoordTuple tuple, AuraQuantity quantity, ForgeDirection direction) {
    }

    public void explosionPushUp(World world, CoordTuple tuple, int power) {
        Explosion explosion = new Explosion(world, null, (double)tuple.getX(), (double)tuple.getY(), (double)tuple.getZ(), 4.0f);
        explosion.field_77286_a = false;
        explosion.field_82755_b = true;
        explosion.func_77279_a(false);
        if (tuple.getTile(world) instanceof AuraTile) {
            AuraTile tile = (AuraTile)tuple.getTile(world);
            tile.verifyConnections();
            for (CoordTuple connectedNode : tile.connected) {
                if (connectedNode.getY() <= tile.field_145848_d) continue;
                AuraTile transferTile = (AuraTile)connectedNode.getTile(world);
                int auraPower = power / (connectedNode.getY() - tile.field_145848_d);
                auraPower = Math.min(auraPower, tile.storage.get(this));
                tile.burst(connectedNode, "magicCrit", this, 1.0);
                tile.storage.subtract(this, auraPower);
                transferTile.storage.add(new AuraQuantity(this, auraPower));
            }
        }
    }
}

