/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.ConsumerTile;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.main.AuraUtil;

public class TileRitualNether
extends ConsumerTile {
    LinkedList<CoordTuple> toSearch = new LinkedList();
    BiomeGenBase targetBiome;
    boolean started = false;

    @Override
    public int getMaxProgress() {
        return 100;
    }

    @Override
    public int getPowerPerProgress() {
        return 5000;
    }

    @Override
    public boolean validItemsNearby() {
        return true;
    }

    public byte getBiomeId() {
        return 8;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        int count = 0;
        if (!this.field_145850_b.field_72995_K && this.toSearch.size() == 0 && this.started) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        while (this.toSearch.size() > 0) {
            CoordTuple tuple = this.toSearch.getFirst();
            this.toSearch.removeFirst();
            int x = tuple.getX();
            int z = tuple.getZ();
            if (new CoordTuple(this).dist(tuple) > 150.0) continue;
            Chunk chunk = this.field_145850_b.func_72938_d(x, z);
            byte[] biomeData = chunk.func_76605_m();
            biomeData[(z & 0xF) << 4 | x & 0xF] = this.getBiomeId();
            boolean particle = true;
            for (int y = 0; y < 255; ++y) {
                Block b = this.getMappedBlock(this.field_145850_b.func_147439_a(x, y, z));
                if (b == null) continue;
                this.field_145850_b.func_147465_d(x, y, z, b, 0, 2);
                if (!particle) continue;
                particle = false;
                AuraCascade.proxy.addBlockDestroyEffects(new CoordTuple(x, y, z));
            }
            if (this.field_145850_b.func_72807_a(x + 1, z) == this.targetBiome && !this.toSearch.contains(new CoordTuple(x + 1, tuple.getY(), z))) {
                this.toSearch.addLast(new CoordTuple(x + 1, tuple.getY(), z));
            }
            if (this.field_145850_b.func_72807_a(x - 1, z) == this.targetBiome && !this.toSearch.contains(new CoordTuple(x - 1, tuple.getY(), z))) {
                this.toSearch.addLast(new CoordTuple(x - 1, tuple.getY(), z));
            }
            if (this.field_145850_b.func_72807_a(x, z + 1) == this.targetBiome && !this.toSearch.contains(new CoordTuple(x, tuple.getY(), z + 1))) {
                this.toSearch.addLast(new CoordTuple(x, tuple.getY(), z + 1));
            }
            if (this.field_145850_b.func_72807_a(x, z - 1) == this.targetBiome && !this.toSearch.contains(new CoordTuple(x + 1, tuple.getY(), z - 1))) {
                this.toSearch.addLast(new CoordTuple(x, tuple.getY(), z - 1));
            }
            if (++count <= 30) continue;
            break;
        }
    }

    @Override
    public void onUsePower() {
        AuraCascade.analytics.eventDesign("consumerRitual", AuraUtil.formatLocation(this));
        if (this.field_145850_b.func_72807_a((int)this.field_145851_c, (int)this.field_145849_e).field_76756_M != this.getBiomeId()) {
            this.toSearch.addFirst(new CoordTuple(this));
            this.targetBiome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
            this.started = true;
        }
    }

    public Block getMappedBlock(Block b) {
        if (b == Blocks.field_150348_b) {
            return Blocks.field_150424_aL;
        }
        if (b == Blocks.field_150349_c || b == Blocks.field_150346_d) {
            return new Random().nextInt(3) == 0 ? Blocks.field_150425_aM : Blocks.field_150424_aL;
        }
        if (b == Blocks.field_150364_r || b == Blocks.field_150363_s || b == Blocks.field_150362_t || b == Blocks.field_150361_u) {
            return Blocks.field_150426_aN;
        }
        if (b == Blocks.field_150329_H) {
            return Blocks.field_150388_bm;
        }
        if (b == Blocks.field_150351_n || b == Blocks.field_150354_m) {
            return Blocks.field_150425_aM;
        }
        if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            return Blocks.field_150353_l;
        }
        if (b == Blocks.field_150433_aE || b == Blocks.field_150431_aC) {
            return Blocks.field_150350_a;
        }
        return null;
    }
}

