/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.ConsumerTile;
import pixlepix.auracascade.main.AuraUtil;

public class FurnaceTile
extends ConsumerTile {
    public static int MAX_PROGRESS = 3;
    public static int POWER_PER_PROGRESS = 190;

    @Override
    public int getMaxProgress() {
        return MAX_PROGRESS;
    }

    @Override
    public int getPowerPerProgress() {
        return POWER_PER_PROGRESS;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public boolean validItemsNearby() {
        int range = 3;
        List nearbyItems = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range)));
        for (EntityItem entityItem : nearbyItems) {
            ItemStack stack = entityItem.func_92059_d();
            if (FurnaceRecipes.func_77602_a().func_151395_a(stack) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void onUsePower() {
        AuraCascade.analytics.eventDesign("consumerSmelt", AuraUtil.formatLocation(this));
        int range = 3;
        List nearbyItems = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range)));
        for (EntityItem entityItem : nearbyItems) {
            ItemStack stack = entityItem.func_92059_d();
            if (FurnaceRecipes.func_77602_a().func_151395_a(stack) == null) continue;
            if (stack.field_77994_a == 0) {
                entityItem.func_70106_y();
            } else {
                --stack.field_77994_a;
            }
            AuraUtil.respawnItemWithParticles(this.field_145850_b, entityItem, FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l());
            break;
        }
    }
}

