/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.transport.IEnderEnergyHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import de.npe.gameanalytics.events.GAErrorEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.AuraTile;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.main.Config;
import pixlepix.auracascade.main.ParticleEffects;

public class AuraTileRF
extends AuraTile {
    public ArrayList<CoordTuple> foundTiles = new ArrayList();
    public HashSet<CoordTuple> particleTiles = new HashSet();
    public int lastPower = 0;
    public boolean disabled = false;
    public String[] blacklist = new String[]{"InductionPort", "EnergyCube", "ChargePad", "EnergyStorage", "TileEntityMagnetic", "TileTransceiver", "TileEntityRift", "TileTransvectorInterface", "TileRemoteInterface", "TileEntityEnergyDistributor", "TileEntityEnderEnergyDistributor", "TileCharger", "TileCell", "TileEntityTransferNodeEnergy", "TileEnergyInfuser"};
    public String[] whitelist = new String[]{"tileentityenderthermiclavapump", "tileentityenderquarry"};
    public String[] blacklistModId = new String[]{"quantumflux"};
    public String[] whitelistModId = new String[]{"buildcraft", "GalacticraftCore", "progressiveautomation", "Mekanism"};

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.lastPower = nbt.func_74762_e("lastPower");
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74768_a("lastPower", this.lastPower);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.foundTiles.clear();
            LinkedList<CoordTuple> nextTiles = new LinkedList<CoordTuple>();
            nextTiles.add(new CoordTuple(this));
            while (nextTiles.size() > 0) {
                CoordTuple target = (CoordTuple)nextTiles.removeFirst();
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    CoordTuple adjacent = target.add(direction);
                    TileEntity entity = adjacent.getTile(this.field_145850_b);
                    if (!(entity instanceof IEnergyReceiver) || nextTiles.contains(adjacent) || this.foundTiles.contains(adjacent)) continue;
                    nextTiles.add(adjacent);
                    this.foundTiles.add(adjacent);
                }
            }
            this.particleTiles.clear();
            for (CoordTuple tuple : this.foundTiles) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    this.particleTiles.add(tuple.add(direction));
                }
            }
            Iterator<CoordTuple> iterator = this.particleTiles.iterator();
            while (iterator.hasNext()) {
                CoordTuple tuple;
                tuple = iterator.next();
                if (!this.foundTiles.contains(tuple)) continue;
                iterator.remove();
            }
            this.disabled = this.foundTiles.size() > 4;
            for (CoordTuple tuple : this.foundTiles) {
                String modid = GameRegistry.findUniqueIdentifierFor((Block)tuple.getBlock((World)this.field_145850_b)).modId;
                TileEntity te = tuple.getTile(this.field_145850_b);
                if (te instanceof IEnderEnergyHandler) {
                    this.disabled = true;
                }
                for (String clazz : this.blacklist) {
                    if (!te.getClass().getName().toLowerCase().contains(clazz.toLowerCase())) continue;
                    boolean whitelistedByMod = false;
                    for (String whitelistMod : this.whitelistModId) {
                        if (!modid.toLowerCase().contains(whitelistMod)) continue;
                        whitelistedByMod = true;
                    }
                    if (whitelistedByMod) continue;
                    this.disabled = true;
                }
                for (String blacklistMod : this.blacklistModId) {
                    if (!modid.equals(blacklistMod)) continue;
                    this.disabled = true;
                }
                if (!(te instanceof IEnergyProvider) || ((IEnergyConnection)te).canConnectEnergy(ForgeDirection.UNKNOWN)) continue;
                AuraCascade.analytics.eventError(GAErrorEvent.Severity.info, "Blacklisted IEnergyProvider authmatically: " + te.getClass().getName());
                boolean isWhitelisted = false;
                for (String clazz : this.whitelist) {
                    if (!te.getClass().getName().toLowerCase().contains(clazz.toLowerCase())) continue;
                    isWhitelisted = true;
                }
                for (String whitelistMod : this.whitelistModId) {
                    if (!modid.toLowerCase().contains(whitelistMod.toLowerCase())) continue;
                    isWhitelisted = true;
                }
                if (isWhitelisted) continue;
                this.disabled = true;
            }
        }
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 3L == 0L) {
            for (CoordTuple tuple : this.particleTiles) {
                Random random = new Random();
                double x = (double)tuple.getX() + random.nextDouble();
                double y = (double)tuple.getY() + random.nextDouble();
                double z = (double)tuple.getZ() + random.nextDouble();
                ParticleEffects.spawnParticle("witchMagic", x, y, z, 0.0, 0.0, 0.0, 255.0, 0.0, !this.disabled ? 50.0 : 0.0);
            }
        }
        if (!this.disabled) {
            int divisions = this.foundTiles.size();
            for (CoordTuple tuple : this.foundTiles) {
                TileEntity entity = tuple.getTile(this.field_145850_b);
                if (entity instanceof IEnergyReceiver && ((IEnergyReceiver)entity).receiveEnergy(ForgeDirection.UNKNOWN, 1, true) > 0) continue;
                --divisions;
            }
            if (divisions > 0) {
                for (CoordTuple tuple : this.foundTiles) {
                    TileEntity entity = tuple.getTile(this.field_145850_b);
                    if (!(entity instanceof IEnergyReceiver)) continue;
                    ((IEnergyReceiver)entity).receiveEnergy(ForgeDirection.UNKNOWN, (int)((float)this.lastPower * Config.powerFactor / (float)divisions), false);
                }
            }
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && !this.field_145850_b.field_72995_K) {
            this.lastPower = 0;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 1L) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void receivePower(int power, EnumAura type) {
        this.lastPower += power;
    }
}

