/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import pixlepix.auracascade.block.tile.AuraTile;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.main.AuraUtil;

public class AuraTilePumpBase
extends AuraTile {
    public int pumpPower;
    public int pumpSpeed;

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.pumpPower = nbt.func_74762_e("pumpPower");
        this.pumpSpeed = nbt.func_74762_e("pumpSpeed");
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74768_a("pumpPower", this.pumpPower);
        nbt.func_74768_a("pumpSpeed", this.pumpSpeed);
    }

    public boolean isAlternator() {
        return false;
    }

    @Override
    public boolean canTransfer(CoordTuple tuple, EnumAura aura) {
        return false;
    }

    @Override
    public boolean canReceive(CoordTuple source, EnumAura aura) {
        return source.getY() <= this.field_145848_d && super.canReceive(source, aura);
    }

    public void addFuel(int time, int speed) {
        if (time * speed > this.pumpSpeed * this.pumpPower) {
            this.pumpSpeed = speed;
            this.pumpPower = time;
            if (this.isAlternator()) {
                this.pumpSpeed *= 3;
            }
        }
        AuraUtil.updateMonitor(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 2L && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.pumpPower > 0) {
            AuraTile upNode = null;
            for (int i = 1; i < 16; ++i) {
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + i, this.field_145849_e);
                if (!(te instanceof AuraTile) || !this.isOpenPath(new CoordTuple(this.field_145851_c, this.field_145848_d + i, this.field_145849_e))) continue;
                upNode = (AuraTile)te;
                break;
            }
            if (upNode != null) {
                --this.pumpPower;
                if (this.pumpPower == 0) {
                    AuraUtil.updateMonitor(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                for (EnumAura aura : EnumAura.values()) {
                    int dist = upNode.field_145848_d - this.field_145848_d;
                    int quantity = this.pumpSpeed / dist;
                    if (this.isAlternator()) {
                        float f = this.getAlternatingFactor();
                        quantity = (int)((float)quantity * f);
                    }
                    quantity = (int)((double)quantity * this.storage.getComposition(aura));
                    quantity = aura.getRelativeMass(this.field_145850_b) == 0.0 ? 0 : (int)((double)quantity / aura.getRelativeMass(this.field_145850_b));
                    quantity = (int)((double)quantity * aura.getAscentBoost(this.field_145850_b));
                    quantity = Math.min(quantity, this.storage.get(aura));
                    this.burst(new CoordTuple(upNode), "magicCrit", aura, 1.0);
                    this.storage.subtract(aura, quantity);
                    upNode.storage.add(new AuraQuantity(aura, quantity));
                }
            }
        }
    }

    public float getAlternatingFactor() {
        return (float)(1.0 + Math.sin(Math.PI * (double)this.field_145850_b.func_82737_E() / 10000.0)) / 2.0f;
    }
}

