/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.AuraBlock;
import pixlepix.auracascade.block.tile.AuraTileBlack;
import pixlepix.auracascade.block.tile.AuraTileCapacitor;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.AuraQuantityList;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.network.PacketBurst;

public class AuraTile
extends TileEntity {
    public AuraQuantityList storage = new AuraQuantityList();
    public HashMap<CoordTuple, AuraQuantityList> burstMap = null;
    public LinkedList<CoordTuple> connected = new LinkedList();
    public boolean hasConnected = false;
    public int energy = 0;
    public int initialYValue = -1;
    public HashMap<CoordTuple, Integer> inducedBurstMap = new HashMap();

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readCustomNBT(nbt);
    }

    protected void readCustomNBT(NBTTagCompound nbt) {
        NBTTagList storageNBT = nbt.func_150295_c("storage", 10);
        this.storage.readFromNBT(storageNBT);
        NBTTagList connectionsNBT = nbt.func_150295_c("connected", 10);
        this.connected = new LinkedList();
        for (int i = 0; i < connectionsNBT.func_74745_c(); ++i) {
            NBTTagCompound coordNBT = connectionsNBT.func_150305_b(i);
            int x = coordNBT.func_74762_e("x");
            int y = coordNBT.func_74762_e("y");
            int z = coordNBT.func_74762_e("z");
            CoordTuple coord = new CoordTuple(x, y, z);
            this.connected.add(coord);
        }
        this.hasConnected = nbt.func_74767_n("hasConnected");
        this.energy = nbt.func_74762_e("energy");
        this.initialYValue = nbt.func_74762_e("initialYValue");
    }

    public boolean connectionBlockedByBlock(CoordTuple tuple) {
        Block block = tuple.getBlock(this.field_145850_b);
        return !block.isAir((IBlockAccess)this.field_145850_b, tuple.getX(), tuple.getY(), tuple.getZ()) && (block instanceof AuraBlock || block.func_149662_c());
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeCustomNBT(nbt);
    }

    protected void writeCustomNBT(NBTTagCompound nbt) {
        NBTTagList storageNBT = new NBTTagList();
        this.storage.writeToNBT(storageNBT);
        nbt.func_74782_a("storage", (NBTBase)storageNBT);
        NBTTagList connectionsNBT = new NBTTagList();
        for (CoordTuple tuple : this.connected) {
            NBTTagCompound coordNBT = new NBTTagCompound();
            coordNBT.func_74768_a("x", tuple.getX());
            coordNBT.func_74768_a("y", tuple.getY());
            coordNBT.func_74768_a("z", tuple.getZ());
            connectionsNBT.func_74742_a((NBTBase)coordNBT);
        }
        nbt.func_74782_a("connected", (NBTBase)connectionsNBT);
        nbt.func_74757_a("hasConnected", this.hasConnected);
        nbt.func_74768_a("energy", this.energy);
        nbt.func_74768_a("initialYValue", this.initialYValue);
    }

    public boolean isOpenPath(CoordTuple target) {
        int dist = (int)new CoordTuple(this).dist(target);
        ForgeDirection direction = new CoordTuple(this).getDirectionTo(target);
        if (direction == ForgeDirection.UNKNOWN) {
            return false;
        }
        for (int i = 1; i < dist; ++i) {
            CoordTuple between = new CoordTuple(this).add(direction, i);
            if (!this.connectionBlockedByBlock(between)) continue;
            return false;
        }
        return true;
    }

    public void verifyConnections() {
        LinkedList<CoordTuple> result = new LinkedList<CoordTuple>();
        for (CoordTuple next : this.connected) {
            TileEntity tile = next.getTile(this.field_145850_b);
            if (!(tile instanceof AuraTile) || !this.isOpenPath(next)) continue;
            if (!((AuraTile)tile).connected.contains(new CoordTuple(this))) {
                ((AuraTile)tile).connected.add(new CoordTuple(this));
            }
            if (result.contains(next)) continue;
            result.add(next);
        }
        this.connected = result;
    }

    public void connect(int x2, int y2, int z2) {
        if (this.field_145850_b.func_147438_o(x2, y2, z2) instanceof AuraTile && this.field_145850_b.func_147438_o(x2, y2, z2) != this && this.isOpenPath(new CoordTuple(x2, y2, z2))) {
            AuraTile otherNode = (AuraTile)this.field_145850_b.func_147438_o(x2, y2, z2);
            otherNode.connected.add(new CoordTuple(this));
            this.connected.add(new CoordTuple(otherNode));
            if (!this.hasConnected) {
                this.burst(new CoordTuple(x2, y2, z2), "spell", EnumAura.WHITE_AURA, 1.0);
            }
        }
    }

    public void burst(CoordTuple target, String particle, EnumAura aura, double composition) {
        AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(new CoordTuple(this), target, particle, aura.r, aura.g, aura.b, composition), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!(this.hasConnected && this.field_145850_b.func_82737_E() % 200L != 0L || this.field_145850_b.field_72995_K)) {
            for (int i = 1; i < 16; ++i) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    this.connect(this.field_145851_c + dir.offsetX * i, this.field_145848_d + dir.offsetY * i, this.field_145849_e + dir.offsetZ * i);
                }
            }
            this.verifyConnections();
            this.hasConnected = true;
        }
        if (this.initialYValue != this.field_145848_d) {
            if (this.initialYValue == -1 || this.initialYValue == 0) {
                this.initialYValue = this.field_145848_d;
            } else {
                Explosion explosion = new Explosion(this.field_145850_b, null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 2.0f);
                explosion.func_77278_a();
                explosion.func_77279_a(false);
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.verifyConnections();
            this.energy = 0;
            this.burstMap = new HashMap();
            double totalWeight = 0.0;
            for (CoordTuple tuple : this.connected) {
                if (!this.canTransfer(tuple)) continue;
                totalWeight += this.getWeight(tuple);
            }
            totalWeight += this instanceof AuraTileCapacitor ? 0.0 : 400.0;
            for (CoordTuple tuple : this.connected) {
                double factor = this.getWeight(tuple) / totalWeight;
                AuraTile other = (AuraTile)tuple.getTile(this.field_145850_b);
                AuraQuantityList quantityList = new AuraQuantityList();
                for (EnumAura enumAura : EnumAura.values()) {
                    int auraThere;
                    int auraHere;
                    int diff;
                    if (!this.canTransfer(tuple, enumAura) || (diff = Math.abs((auraHere = this.storage.get(enumAura)) - (auraThere = other.storage.get(enumAura)))) <= 25) continue;
                    quantityList.add(new AuraQuantity(enumAura, (int)((float)auraHere * (float)factor)));
                }
                if (quantityList.empty()) continue;
                this.burstMap.put(tuple, quantityList);
            }
        }
        if (this.field_145850_b.func_82737_E() % 20L == 1L) {
            this.verifyConnections();
            if (this.burstMap != null) {
                for (CoordTuple tuple : this.connected) {
                    if (!this.burstMap.containsKey(tuple)) continue;
                    this.transferAura(tuple, this.burstMap.get(tuple), true);
                }
                this.burstMap = null;
            }
        }
        if (this.field_145850_b.func_82737_E() % 20L == 2L) {
            this.verifyConnections();
            if (this.inducedBurstMap != null) {
                for (CoordTuple tuple : this.connected) {
                    int deltaFlow;
                    if (!this.inducedBurstMap.containsKey(tuple)) continue;
                    int num = this.inducedBurstMap.get(tuple);
                    AuraTile otherTile = (AuraTile)tuple.getTile(this.field_145850_b);
                    int altNum = 0;
                    if (otherTile.inducedBurstMap != null) {
                        altNum = otherTile.inducedBurstMap.containsKey(new CoordTuple(this)) ? otherTile.inducedBurstMap.get(new CoordTuple(this)) : 0;
                        deltaFlow = num - altNum;
                    } else {
                        deltaFlow = num;
                    }
                    if (deltaFlow > 0) {
                        AuraQuantityList auraToSend = (AuraQuantityList)this.storage.clone();
                        otherTile.inducedBurstMap.put(new CoordTuple(this), 0);
                        auraToSend.set(EnumAura.ORANGE_AURA, 0);
                        if (auraToSend.getTotalAura() <= 0) continue;
                        auraToSend = auraToSend.percent(Math.min(1.0f, (float)deltaFlow / (float)this.storage.getTotalAura()) - (float)this.storage.get(EnumAura.ORANGE_AURA));
                        this.transferAura(tuple, auraToSend, false);
                        continue;
                    }
                    this.inducedBurstMap.put(tuple, 0);
                    if (otherTile.inducedBurstMap == null) continue;
                    otherTile.inducedBurstMap.put(new CoordTuple(this), altNum - num);
                }
                this.inducedBurstMap = new HashMap();
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        for (AuraQuantity quantity : this.storage.quantityList) {
            if (quantity.getNum() <= 0) continue;
            quantity.getType().updateTick(this.field_145850_b, new CoordTuple(this), quantity);
        }
    }

    public void transferAura(CoordTuple tuple, AuraQuantityList list, boolean triggerOrange) {
        if (this.storage.greaterThan(list)) {
            ((AuraTile)tuple.getTile((World)this.field_145850_b)).storage.add(list);
            this.storage.subtract(list);
            for (EnumAura aura : EnumAura.values()) {
                if (list.get(aura) <= 0) continue;
                this.burst(tuple, "square", aura, list.getComposition(aura));
                int power = (int)((double)((this.field_145848_d - tuple.getY()) * list.get(aura)) * aura.getRelativeMass(this.field_145850_b));
                if (power > 0) {
                    ((AuraTile)tuple.getTile(this.field_145850_b)).receivePower(power, aura);
                }
                if (!triggerOrange && aura == EnumAura.ORANGE_AURA || list.get(aura) == 0) continue;
                aura.onTransfer(this.field_145850_b, new CoordTuple(this), new AuraQuantity(aura, list.get(aura)), new CoordTuple(this).getDirectionTo(tuple));
            }
        }
    }

    public void receivePower(int power, EnumAura type) {
        this.energy += power;
    }

    public boolean canTransfer(CoordTuple tuple) {
        boolean isSame;
        boolean isLower = tuple.getY() < this.field_145848_d;
        boolean bl = isSame = tuple.getY() == this.field_145848_d;
        if (!(tuple.getTile(this.field_145850_b) instanceof AuraTile)) {
            return false;
        }
        if (!isSame && !isLower) {
            return false;
        }
        return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this instanceof AuraTileBlack;
    }

    public boolean canTransfer(CoordTuple tuple, EnumAura aura) {
        if (!this.canTransfer(tuple)) {
            return false;
        }
        if (tuple.getY() != this.field_145848_d && aura == EnumAura.ORANGE_AURA) {
            return false;
        }
        if (tuple.getY() == this.field_145848_d && aura == EnumAura.BLACK_AURA) {
            return false;
        }
        return ((AuraTile)tuple.getTile(this.field_145850_b)).canReceive(new CoordTuple(this), aura);
    }

    public boolean canReceive(CoordTuple source, EnumAura aura) {
        return true;
    }

    public double getWeight(CoordTuple tuple) {
        return Math.pow(20.0 - tuple.dist(this), 2.0);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeCustomNBT(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }
}

