/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block;

import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.AuraTile;
import pixlepix.auracascade.block.tile.AuraTileBlack;
import pixlepix.auracascade.block.tile.AuraTileCapacitor;
import pixlepix.auracascade.block.tile.AuraTileConserve;
import pixlepix.auracascade.block.tile.AuraTileOrange;
import pixlepix.auracascade.block.tile.AuraTilePedestal;
import pixlepix.auracascade.block.tile.AuraTilePump;
import pixlepix.auracascade.block.tile.AuraTilePumpAlt;
import pixlepix.auracascade.block.tile.AuraTilePumpBase;
import pixlepix.auracascade.block.tile.AuraTilePumpCreative;
import pixlepix.auracascade.block.tile.AuraTilePumpFall;
import pixlepix.auracascade.block.tile.AuraTilePumpFallAlt;
import pixlepix.auracascade.block.tile.AuraTilePumpLight;
import pixlepix.auracascade.block.tile.AuraTilePumpLightAlt;
import pixlepix.auracascade.block.tile.AuraTilePumpProjectile;
import pixlepix.auracascade.block.tile.AuraTilePumpProjectileAlt;
import pixlepix.auracascade.block.tile.AuraTilePumpRedstone;
import pixlepix.auracascade.block.tile.AuraTilePumpRedstoneAlt;
import pixlepix.auracascade.block.tile.AuraTileRF;
import pixlepix.auracascade.block.tile.CraftingCenterTile;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.data.IToolTip;
import pixlepix.auracascade.item.ItemAuraCrystal;
import pixlepix.auracascade.item.ItemMaterial;
import pixlepix.auracascade.main.AuraUtil;
import pixlepix.auracascade.main.Config;
import pixlepix.auracascade.main.EnumColor;
import pixlepix.auracascade.network.PacketBurst;
import pixlepix.auracascade.registry.BlockRegistry;
import pixlepix.auracascade.registry.CraftingBenchRecipe;
import pixlepix.auracascade.registry.ITTinkererBlock;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;

public class AuraBlock
extends Block
implements IToolTip,
ITTinkererBlock,
ITileEntityProvider {
    public static String name = "auraNode";
    String type;
    private IIcon topIcon;
    private IIcon sideIcon;
    private IIcon botIcon;

    public AuraBlock(String type) {
        super(Material.field_151592_s);
        this.type = type;
        if (!type.equals("craftingCenter")) {
            this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        }
        this.func_149713_g(0);
        this.func_149711_c(2.0f);
    }

    public AuraBlock() {
        this("");
        this.func_149711_c(2.0f);
    }

    public static AuraBlock getBlockFromName(String name) {
        ArrayList<Block> blockList = BlockRegistry.getBlockFromClass(AuraBlock.class);
        for (Block b : blockList) {
            if (!((AuraBlock)b).type.equals(name)) continue;
            return (AuraBlock)b;
        }
        return null;
    }

    public static ItemStack getAuraNodeItemstack() {
        ArrayList<Block> blockList = BlockRegistry.getBlockFromClass(AuraBlock.class);
        for (Block b : blockList) {
            if (!((AuraBlock)b).type.equals("")) continue;
            return new ItemStack(b);
        }
        AuraCascade.log.warn("Failed to find aura node itemstack. Something has gone horribly wrong");
        return null;
    }

    public static ItemStack getAuraNodePumpItemstack() {
        ArrayList<Block> blockList = BlockRegistry.getBlockFromClass(AuraBlock.class);
        for (Block b : blockList) {
            if (!((AuraBlock)b).type.equals("pump")) continue;
            return new ItemStack(b);
        }
        AuraCascade.log.warn("Failed to find aura node pump itemstack. Something has gone horribly wrong");
        return null;
    }

    public static boolean _Immovable() {
        return true;
    }

    public String getHarvestTool(int metadata) {
        return "pickaxe";
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof AuraTile) {
            int aura = ((AuraTile)tileEntity).storage.getTotalAura();
            return (int)Math.floor(Math.log10(aura));
        }
        return super.func_149736_g(world, x, y, z, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fx, float fy, float fz) {
        if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof AuraTile) {
            if (world.func_147438_o(x, y, z) instanceof AuraTileCapacitor && player.func_70093_af()) {
                AuraTileCapacitor capacitor = (AuraTileCapacitor)world.func_147438_o(x, y, z);
                capacitor.storageValueIndex = (capacitor.storageValueIndex + 1) % capacitor.storageValues.length;
                player.func_146105_b((IChatComponent)new ChatComponentText("Max Storage: " + capacitor.storageValues[capacitor.storageValueIndex]));
                world.func_147471_g(x, y, z);
                return true;
            }
            if (world.func_147438_o(x, y, z) instanceof AuraTilePedestal && !player.func_70093_af()) {
                AuraTilePedestal pedestal = (AuraTilePedestal)world.func_147438_o(x, y, z);
                if (pedestal.itemStack != null) {
                    EntityItem item = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, pedestal.itemStack);
                    world.func_72838_d((Entity)item);
                }
                pedestal.itemStack = player.field_71071_by.func_70448_g() != null ? player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1) : null;
                world.func_147471_g(x, y, z);
                world.func_147444_c(x, y, z, (Block)this);
                return true;
            }
            if (world.func_147438_o(x, y, z) instanceof AuraTile && player.field_71071_by.func_70448_g() == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Aura:"));
                for (EnumAura aura : EnumAura.values()) {
                    if (((AuraTile)world.func_147438_o((int)x, (int)y, (int)z)).storage.get(aura) == 0) continue;
                    player.func_146105_b((IChatComponent)new ChatComponentText(aura.name + " Aura: " + ((AuraTile)world.func_147438_o((int)x, (int)y, (int)z)).storage.get(aura)));
                }
                if (world.func_147438_o(x, y, z) instanceof AuraTilePumpBase) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Power: " + ((AuraTilePumpBase)world.func_147438_o((int)x, (int)y, (int)z)).pumpPower));
                }
                return true;
            }
        } else if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof CraftingCenterTile && player.field_71071_by.func_70448_g() == null) {
            CraftingCenterTile tile = (CraftingCenterTile)world.func_147438_o(x, y, z);
            if (tile.getRecipe() != null) {
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "Making: " + tile.getRecipe().result.func_82833_r()));
                for (ForgeDirection direction : CraftingCenterTile.pedestalRelativeLocations) {
                    AuraTilePedestal pedestal = (AuraTilePedestal)new CoordTuple(x, y, z).add(direction).getTile(world);
                    if (tile.getRecipe() != null && tile.getRecipe().getAuraFromItem(pedestal.itemStack) != null) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("" + (Object)((Object)EnumColor.AQUA) + pedestal.powerReceived + "/" + tile.getRecipe().getAuraFromItem(pedestal.itemStack).getNum() + " (" + tile.getRecipe().getAuraFromItem((ItemStack)pedestal.itemStack).getType().name + ")"));
                        continue;
                    }
                    AuraCascade.log.warn("Invalid recipe when checking crafting center");
                }
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText("No Recipe Selected"));
            }
            return true;
        }
        return true;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        ItemStack stack;
        super.func_149670_a(world, x, y, z, entity);
        TileEntity te = world.func_147438_o(x, y, z);
        if (entity instanceof EntityItem && !world.field_72995_K && (stack = ((EntityItem)entity).func_92059_d()).func_77973_b() instanceof ItemAuraCrystal && te instanceof AuraTile) {
            ((AuraTile)te).storage.add(new AuraQuantity(EnumAura.values()[stack.func_77960_j()], 1000 * stack.field_77994_a));
            world.func_147471_g(x, y, z);
            world.func_147444_c(x, y, z, (Block)this);
            AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(1, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 32.0));
            entity.func_70106_y();
        }
        if (!world.field_72995_K && te instanceof AuraTilePumpProjectile) {
            ((AuraTilePumpProjectile)te).onEntityCollidedWithBlock(entity);
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (this.type.contains("Alt")) {
            this.topIcon = iconRegister.func_94245_a("aura:" + this.type.replace("Alt", "") + "Node_Top");
            this.sideIcon = iconRegister.func_94245_a("aura:" + this.type.replace("Alt", "") + "Node_Side_Alt");
            this.botIcon = iconRegister.func_94245_a("aura:" + this.type.replace("Alt", "") + "Node_Bottom");
        } else {
            this.sideIcon = iconRegister.func_94245_a("aura:" + this.type + "Node_Side");
            this.botIcon = iconRegister.func_94245_a("aura:" + this.type + "Node_Bottom");
            this.topIcon = iconRegister.func_94245_a("aura:" + this.type + "Node_Top");
        }
    }

    public void func_149714_e(World world, int x, int y, int z, int p_149714_5_) {
        super.func_149714_e(world, x, y, z, p_149714_5_);
        AuraUtil.updateMonitor(world, x, y, z);
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.botIcon;
            }
            case 1: {
                return this.topIcon;
            }
        }
        return this.sideIcon;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null) continue;
                double d0 = AuraUtil.getDropOffset(world);
                double d1 = AuraUtil.getDropOffset(world);
                double d2 = AuraUtil.getDropOffset(world);
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, inv.func_70301_a(i));
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
        AuraUtil.updateMonitor(world, x, y, z);
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        if (this.type.equals("pump")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "ILI", "INI", "ILI", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('L'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('N'), AuraBlock.getAuraNodeItemstack());
        }
        if (this.type.equals("black")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), " I ", " N ", " I ", Character.valueOf('I'), ItemMaterial.getIngot(EnumAura.BLACK_AURA), Character.valueOf('N'), AuraBlock.getAuraNodeItemstack());
        }
        if (this.type.equals("conserve")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "B", "N", "B", Character.valueOf('B'), ItemMaterial.getIngot(EnumAura.BLUE_AURA), Character.valueOf('N'), AuraBlock.getAuraNodeItemstack());
        }
        if (this.type.equals("capacitor")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "Y", "N", "G", Character.valueOf('Y'), ItemMaterial.getIngot(EnumAura.YELLOW_AURA), Character.valueOf('G'), ItemMaterial.getIngot(EnumAura.GREEN_AURA), Character.valueOf('N'), AuraBlock.getAuraNodeItemstack());
        }
        if (this.type.equals("craftingPedestal")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "BBB", "BNB", "BBB", Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('N'), AuraBlock.getAuraNodeItemstack());
        }
        if (this.type.equals("craftingCenter")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "GGG", "RDR", "RRR", Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('R'), ItemMaterial.getIngot(EnumAura.RED_AURA), Character.valueOf('D'), new ItemStack(Items.field_151045_i));
        }
        if (this.type.equals("orange")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), " O ", " N ", " O ", Character.valueOf('O'), ItemMaterial.getIngot(EnumAura.ORANGE_AURA), Character.valueOf('N'), AuraBlock.getAuraNodeItemstack());
        }
        if (this.type.equals("pumpProjectile")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "XXX", "GPG", Character.valueOf('X'), new ItemStack(Items.field_151032_g), Character.valueOf('G'), ItemMaterial.getIngot(EnumAura.VIOLET_AURA), Character.valueOf('P'), AuraBlock.getAuraNodePumpItemstack());
        }
        if (this.type.equals("pumpFall")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "XXX", "GPG", Character.valueOf('X'), new ItemStack(Items.field_151131_as), Character.valueOf('G'), ItemMaterial.getIngot(EnumAura.BLUE_AURA), Character.valueOf('P'), AuraBlock.getAuraNodePumpItemstack());
        }
        if (this.type.equals("pumpLight")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "XXX", "GPG", "G G", Character.valueOf('X'), new ItemStack(Blocks.field_150426_aN), Character.valueOf('G'), ItemMaterial.getIngot(EnumAura.YELLOW_AURA), Character.valueOf('P'), AuraBlock.getAuraNodePumpItemstack());
        }
        if (this.type.equals("pumpRedstone")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "XXX", "GPG", "G G", Character.valueOf('X'), new ItemStack(Blocks.field_150451_bX), Character.valueOf('G'), ItemMaterial.getIngot(EnumAura.RED_AURA), Character.valueOf('P'), AuraBlock.getAuraNodePumpItemstack());
        }
        if (this.type.equals("pumpAlt")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), " E ", "EPE", " E ", Character.valueOf('P'), new ItemStack((Block)AuraBlock.getBlockFromName("pump")), Character.valueOf('E'), Items.field_151137_ax);
        }
        if (this.type.equals("pumpRedstoneAlt")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), " E ", "EPE", " E ", Character.valueOf('P'), new ItemStack((Block)AuraBlock.getBlockFromName("pumpRedstone")), Character.valueOf('E'), Items.field_151137_ax);
        }
        if (this.type.equals("pumpLightAlt")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), " E ", "EPE", " E ", Character.valueOf('P'), new ItemStack((Block)AuraBlock.getBlockFromName("pumpLight")), Character.valueOf('E'), Items.field_151137_ax);
        }
        if (this.type.equals("pumpFallAlt")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), " E ", "EPE", " E ", Character.valueOf('P'), new ItemStack((Block)AuraBlock.getBlockFromName("pumpFall")), Character.valueOf('E'), Items.field_151137_ax);
        }
        if (this.type.equals("pumpProjectileAlt")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), " E ", "EPE", " E ", Character.valueOf('P'), new ItemStack((Block)AuraBlock.getBlockFromName("pumpProjectile")), Character.valueOf('E'), Items.field_151137_ax);
        }
        if (this.type.equals("flux")) {
            return new CraftingBenchRecipe(new ItemStack((Block)this), "RNR", Character.valueOf('R'), ItemMaterial.getIngot(EnumAura.RED_AURA), Character.valueOf('N'), AuraBlock.getAuraNodeItemstack());
        }
        if (this.type.equals("pumpCreative")) {
            return null;
        }
        return new CraftingBenchRecipe(new ItemStack((Block)this, 4), "PPP", "PRP", "PPP", Character.valueOf('P'), new ItemStack(Items.field_151074_bl), Character.valueOf('R'), new ItemStack(Items.field_151137_ax));
    }

    @Override
    public int getCreativeTabPriority() {
        if (this.type.equals("pump") || this.type.equals("") || this.type.equals("flux")) {
            return 100;
        }
        if (this.type.contains("Alt")) {
            return -25;
        }
        if (this.type.contains("pump")) {
            return 75;
        }
        return 50;
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("pump");
        result.add("black");
        result.add("conserve");
        result.add("capacitor");
        result.add("craftingCenter");
        result.add("craftingPedestal");
        result.add("orange");
        result.add("pumpAlt");
        result.add("pumpProjectile");
        result.add("pumpFall");
        result.add("pumpLight");
        result.add("pumpRedstone");
        result.add("pumpProjectileAlt");
        result.add("pumpFallAlt");
        result.add("pumpCreative");
        result.add("pumpLightAlt");
        result.add("pumpRedstoneAlt");
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy")) {
            result.add("flux");
        }
        return result;
    }

    @Override
    public String getBlockName() {
        return name + this.type;
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    @Override
    public Class<? extends ItemBlock> getItemBlock() {
        return null;
    }

    @Override
    public Class<? extends TileEntity> getTileEntity() {
        if (this.type.equals("pump")) {
            return AuraTilePump.class;
        }
        if (this.type.equals("black")) {
            return AuraTileBlack.class;
        }
        if (this.type.equals("conserve")) {
            return AuraTileConserve.class;
        }
        if (this.type.equals("capacitor")) {
            return AuraTileCapacitor.class;
        }
        if (this.type.equals("craftingPedestal")) {
            return AuraTilePedestal.class;
        }
        if (this.type.equals("craftingCenter")) {
            return CraftingCenterTile.class;
        }
        if (this.type.equals("flux")) {
            return AuraTileRF.class;
        }
        if (this.type.equals("pumpCreative")) {
            return AuraTilePumpCreative.class;
        }
        if (this.type.equals("orange")) {
            return AuraTileOrange.class;
        }
        if (this.type.equals("pumpProjectile")) {
            return AuraTilePumpProjectile.class;
        }
        if (this.type.equals("pumpFall")) {
            return AuraTilePumpFall.class;
        }
        if (this.type.equals("pumpCreative")) {
            return AuraTilePumpFall.class;
        }
        if (this.type.equals("pumpLight")) {
            return AuraTilePumpLight.class;
        }
        if (this.type.equals("pumpRedstone")) {
            return AuraTilePumpRedstone.class;
        }
        if (this.type.equals("pumpAlt")) {
            return AuraTilePumpAlt.class;
        }
        if (this.type.equals("pumpProjectileAlt")) {
            return AuraTilePumpProjectileAlt.class;
        }
        if (this.type.equals("pumpFallAlt")) {
            return AuraTilePumpFallAlt.class;
        }
        if (this.type.equals("pumpLightAlt")) {
            return AuraTilePumpLightAlt.class;
        }
        if (this.type.equals("pumpRedstoneAlt")) {
            return AuraTilePumpRedstoneAlt.class;
        }
        return AuraTile.class;
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return this.getTileEntity().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @Override
    public List<String> getTooltipData(World world, EntityPlayer player, int x, int y, int z) {
        ArrayList<String> result = new ArrayList<String>();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof AuraTile) {
            if (tileEntity instanceof AuraTileCapacitor) {
                AuraTileCapacitor capacitor = (AuraTileCapacitor)tileEntity;
                result.add("Max Storage: " + capacitor.storageValues[capacitor.storageValueIndex]);
            }
            if (((AuraTile)tileEntity).storage.getTotalAura() > 0) {
                result.add("Aura Stored: ");
                for (EnumAura aura : EnumAura.values()) {
                    if (((AuraTile)tileEntity).storage.get(aura) == 0) continue;
                    result.add("    " + aura.name + " Aura: " + ((AuraTile)tileEntity).storage.get(aura));
                }
            } else {
                result.add("No Aura");
            }
            if (tileEntity instanceof AuraTileCapacitor && ((AuraTileCapacitor)tileEntity).ticksDisabled > 0) {
                result.add("Time until functional: " + ((AuraTileCapacitor)tileEntity).ticksDisabled / 20);
            }
            if (tileEntity instanceof AuraTilePumpBase) {
                result.add("Time left: " + ((AuraTilePumpBase)tileEntity).pumpPower + " seconds");
                result.add("Power: " + ((AuraTilePumpBase)tileEntity).pumpSpeed + " power per second");
                if (((AuraTilePumpBase)tileEntity).isAlternator()) {
                    AuraTilePumpBase altPump = (AuraTilePumpBase)tileEntity;
                    int power = (int)((float)altPump.pumpSpeed * altPump.getAlternatingFactor());
                    result.add("Phase Power: " + power);
                }
            }
            if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy") && tileEntity instanceof AuraTileRF) {
                AuraTileRF auraTileRF = (AuraTileRF)tileEntity;
                result.add("RF/t Output: " + (float)auraTileRF.lastPower * Config.powerFactor);
            }
        } else if (tileEntity instanceof CraftingCenterTile) {
            CraftingCenterTile tile = (CraftingCenterTile)tileEntity;
            if (tile.getRecipe() != null) {
                result.add("Making: " + tile.getRecipe().result.func_82833_r());
                for (ForgeDirection direction : CraftingCenterTile.pedestalRelativeLocations) {
                    AuraTilePedestal pedestal = (AuraTilePedestal)new CoordTuple(x, y, z).add(direction).getTile(world);
                    if (tile.getRecipe() != null && tile.getRecipe().getAuraFromItem(pedestal.itemStack) != null) {
                        result.add("    Power received:" + pedestal.powerReceived + "/" + tile.getRecipe().getAuraFromItem(pedestal.itemStack).getNum() + " (" + tile.getRecipe().getAuraFromItem((ItemStack)pedestal.itemStack).getType().name + ")");
                        continue;
                    }
                    AuraCascade.log.warn("Invalid recipe when checking crafting center");
                }
            } else {
                result.add("No Valid Recipe Selected");
            }
        }
        return result;
    }
}

