/*
 * Decompiled with CFR 0.152.
 */
package de.npe.gameanalytics;

import de.npe.gameanalytics.EventHandler;
import de.npe.gameanalytics.events.GABusinessEvent;
import de.npe.gameanalytics.events.GADesignEvent;
import de.npe.gameanalytics.events.GAErrorEvent;
import de.npe.gameanalytics.events.GAEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;

public abstract class Analytics {
    private String sessionID;
    private String userID;
    private KeyPair keyPair;

    public abstract boolean isActive();

    public abstract String gameKey();

    public abstract String secretKey();

    public abstract String build();

    public abstract String userPrefix();

    public synchronized String getUserID() {
        if (this.userID == null) {
            this.userID = "unknown";
            try {
                UUID uuid;
                Properties config = this.loadConfig();
                try {
                    uuid = UUID.fromString(config.getProperty("user_id"));
                }
                catch (Exception e) {
                    uuid = UUID.randomUUID();
                    config.setProperty("user_id", uuid.toString());
                    this.saveConfig(config);
                }
                this.userID = uuid.toString();
            }
            catch (Exception e) {
                System.err.println("Error when loading analytics config");
                e.printStackTrace(System.err);
            }
        }
        return this.userPrefix() + this.userID;
    }

    public synchronized String getSessionID() {
        if (this.sessionID == null) {
            this.sessionID = String.valueOf(System.currentTimeMillis());
        }
        return this.sessionID;
    }

    protected String getAnaylitcsConfigRootPath() {
        return ".analytics";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadConfig() throws IOException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Properties config = new Properties();
            File file = this.getConfigFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (FileInputStream fis = new FileInputStream(file);){
                config.load(fis);
            }
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig(Properties config) throws IOException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            File file = this.getConfigFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                config.store(fos, null);
            }
        }
    }

    protected String getConfigFileName() {
        return this.getClass().getCanonicalName();
    }

    private File getConfigFile() {
        return new File(this.getAnaylitcsConfigRootPath(), this.getConfigFileName() + ".properties");
    }

    public final void event(GAEvent event, boolean immediate) {
        if (this.isActive()) {
            if (immediate) {
                EventHandler.queueImmediateSend(event);
            } else {
                EventHandler.add(event);
            }
        }
    }

    public final void eventError(GAErrorEvent.Severity severity, String message) {
        if (this.isActive()) {
            switch (severity) {
                case critical: 
                case error: {
                    EventHandler.queueImmediateSend(new GAErrorEvent(this, severity, message));
                    break;
                }
                case warning: 
                case info: 
                case debug: {
                    EventHandler.add(new GAErrorEvent(this, severity, message));
                    break;
                }
                default: {
                    System.err.println("Unhandled severity for analytics: " + severity.name());
                }
            }
        }
    }

    public final void eventErrorNow(GAErrorEvent.Severity severity, String message) {
        if (this.isActive()) {
            EventHandler.sendErrorNow(new GAErrorEvent(this, severity, message), true);
        }
    }

    protected final void eventErrorNOW(GAErrorEvent.Severity severity, String message) {
        if (this.isActive()) {
            EventHandler.sendErrorNow(new GAErrorEvent(this, severity, message), false);
        }
    }

    public final void eventDesign(String eventID) {
        if (this.isActive()) {
            EventHandler.add(new GADesignEvent(this, eventID, null, null));
        }
    }

    public final void eventDesign(String eventID, String area) {
        if (this.isActive()) {
            EventHandler.add(new GADesignEvent(this, eventID, area, null));
        }
    }

    public final void eventDesign(String eventID, Number value) {
        if (this.isActive()) {
            EventHandler.add(new GADesignEvent(this, eventID, null, value));
        }
    }

    public final void eventDesign(String eventID, String area, Number value) {
        if (this.isActive()) {
            EventHandler.add(new GADesignEvent(this, eventID, area, value));
        }
    }

    public final void eventBusiness(String eventID, String area, int amount, String currency) {
        if (this.isActive()) {
            EventHandler.queueImmediateSend(new GABusinessEvent(this, eventID, area, amount, currency));
        }
    }

    public final KeyPair keyPair() {
        if (this.keyPair == null) {
            this.keyPair = new KeyPair();
        }
        return this.keyPair;
    }

    public final class KeyPair {
        public final String gameKey;
        public final String secretKey;

        public KeyPair() {
            this.gameKey = Analytics.this.gameKey();
            this.secretKey = Analytics.this.secretKey();
        }

        public int hashCode() {
            return this.gameKey.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeyPair)) {
                return false;
            }
            KeyPair other = (KeyPair)obj;
            return this.gameKey.equals(other.gameKey) && this.secretKey.equals(other.secretKey);
        }

        public String toString() {
            return "KeyPair: hasGameKey=" + (this.gameKey != null) + ", hasSecretKey=" + (this.secretKey != null);
        }
    }
}

