/*
 * Decompiled with CFR 0.152.
 */
package mcjty.varia;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Logging {
    private static Logging instance = null;
    public static long prevTicks = -1L;
    private Logger logger = LogManager.getLogger();
    public static boolean debugMode = false;
    public static boolean doLogging = false;

    private Logging() {
        instance = this;
    }

    private static Logging getInstance() {
        if (instance == null) {
            instance = new Logging();
        }
        return instance;
    }

    public static void logError(String msg) {
        Logging.getInstance().logger.log(Level.ERROR, msg);
    }

    public static void log(World world, TileEntity te, String message) {
        if (doLogging) {
            long ticks = world.func_82737_E();
            if (ticks != prevTicks) {
                prevTicks = ticks;
                Logging.getInstance().logger.log(Level.INFO, "=== Time " + ticks + " ===");
            }
            String id = te.field_145851_c + "," + te.field_145848_d + "," + te.field_145849_e + ": ";
            Logging.getInstance().logger.log(Level.INFO, id + message);
        }
    }

    public static void log(String message) {
        Logging.getInstance().logger.log(Level.INFO, message);
    }

    public static void logDebug(String message) {
        if (debugMode) {
            Logging.getInstance().logger.log(Level.INFO, message);
        }
    }

    public static void message(EntityPlayer player, String message) {
        player.func_146105_b((IChatComponent)new ChatComponentText(message));
    }

    public static void warn(EntityPlayer player, String message) {
        player.func_146105_b(new ChatComponentText(message).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
    }
}

