/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.base.ModBase;
import mcjty.gui.GuiConfig;
import mcjty.gui.GuiStyle;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.network.PacketSetGuiStyle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class GuiSideWindow {
    protected GuiStyle style;
    private final List<WidgetList> styledLists = new ArrayList<WidgetList>();
    protected Window sideWindow;
    private Button guiButton;
    private Button helpButton;
    private int sideLeft;
    private int sideTop;
    private int manual;
    private String manualNode;

    public GuiSideWindow(int manual, String manualNode) {
        this.manual = manual;
        this.manualNode = manualNode;
    }

    public void initGui(final ModBase modBase, final SimpleNetworkWrapper network, final Minecraft mc, GuiScreen gui, int guiLeft, int guiTop, int xSize, int ySize) {
        this.style = modBase.getGuiStyle((EntityPlayer)mc.field_71439_g);
        this.helpButton = ((Button)((Button)((Button)new Button(mc, (Gui)gui).setText("?")).setLayoutHint(new PositionalLayout.PositionalHint(1, 1, 16, 16))).setTooltips(new String[]{"Open manual"})).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiSideWindow.this.help(modBase, mc);
            }
        });
        this.guiButton = ((Button)((Button)new Button(mc, (Gui)gui).setText("s")).setLayoutHint(new PositionalLayout.PositionalHint(1, 19, 16, 16))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiSideWindow.this.changeStyle(modBase, network);
            }
        });
        this.setStyleTooltip();
        Panel sidePanel = (Panel)((Panel)new Panel(mc, (Gui)gui).setLayout(new PositionalLayout()).addChild(this.guiButton)).addChild(this.helpButton);
        this.sideLeft = guiLeft + xSize;
        this.sideTop = guiTop + (ySize - 20) / 2 - 8;
        sidePanel.setBounds(new Rectangle(this.sideLeft, this.sideTop, 20, 40));
        this.sideWindow = new Window(gui, sidePanel);
    }

    private void help(ModBase modBase, Minecraft mc) {
        EntityClientPlayerMP player = mc.field_71439_g;
        modBase.openManual((EntityPlayer)player, this.manual, this.manualNode);
    }

    private void setStyleTooltip() {
        this.guiButton.setTooltips(new String[]{"Gui style:", this.style.getStyle()});
    }

    private void changeStyle(ModBase modBase, SimpleNetworkWrapper network) {
        int next = this.style.ordinal() + 1;
        if (next >= GuiStyle.values().length) {
            next = 0;
        }
        this.style = GuiStyle.values()[next];
        network.sendToServer((IMessage)new PacketSetGuiStyle(modBase, this.style.getStyle()));
        this.setStyleTooltip();
        for (WidgetList list : this.styledLists) {
            list.setFilledRectThickness(0);
            list.setFilledBackground(-1);
            this.updateStyle(list);
        }
    }

    private void updateStyle(WidgetList list) {
        if (this.style == GuiStyle.STYLE_BEVEL) {
            list.setFilledRectThickness(1);
        } else {
            list.setFilledBackground(GuiConfig.itemListBackground);
        }
    }

    public void register(WidgetList list) {
        this.updateStyle(list);
        this.styledLists.add(list);
    }

    public Window getWindow() {
        return this.sideWindow;
    }
}

