/*
 * Decompiled with CFR 0.152.
 */
package mcjty.container;

import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.Map;
import mcjty.container.BaseSlot;
import mcjty.container.ContainerFactory;
import mcjty.container.CraftingSlot;
import mcjty.container.GenericCrafter;
import mcjty.container.GhostOutputSlot;
import mcjty.container.GhostSlot;
import mcjty.container.SlotDefinition;
import mcjty.container.SlotFactory;
import mcjty.container.SlotRanges;
import mcjty.container.SlotType;
import mcjty.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GenericContainer
extends Container {
    protected Map<String, IInventory> inventories = new HashMap<String, IInventory>();
    private ContainerFactory factory;
    private GenericCrafter crafter = null;

    public GenericContainer(ContainerFactory factory) {
        this.factory = factory;
    }

    public void addInventory(String name, IInventory inventory) {
        this.inventories.put(name, inventory);
    }

    public IInventory getInventory(String name) {
        return this.inventories.get(name);
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        for (IInventory inventory : this.inventories.values()) {
            if (inventory.func_70300_a(entityPlayer)) continue;
            return false;
        }
        return true;
    }

    public SlotType getSlotType(int index) {
        return this.factory.getSlotType(index);
    }

    public GenericCrafter getCrafter() {
        return this.crafter;
    }

    public void setCrafter(GenericCrafter crafter) {
        this.crafter = crafter;
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : this.factory.getSlots()) {
            IInventory inventory = this.inventories.get(slotFactory.getInventoryName());
            int index = slotFactory.getIndex();
            int x = slotFactory.getX();
            int y = slotFactory.getY();
            SlotType slotType = slotFactory.getSlotType();
            Slot slot = this.createSlot(slotFactory, inventory, index, x, y, slotType);
            this.func_75146_a(slot);
        }
    }

    protected Slot createSlot(SlotFactory slotFactory, IInventory inventory, int index, int x, int y, SlotType slotType) {
        Slot slot;
        if (slotType == SlotType.SLOT_GHOST) {
            slot = new GhostSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_GHOSTOUT) {
            slot = new GhostOutputSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_SPECIFICITEM) {
            final SlotDefinition slotDefinition = slotFactory.getSlotDefinition();
            slot = new Slot(inventory, index, x, y){

                public boolean func_75214_a(ItemStack stack) {
                    return slotDefinition.itemStackMatches(stack);
                }
            };
        } else {
            slot = slotType == SlotType.SLOT_CRAFTRESULT ? new CraftingSlot(inventory, index, x, y, this.crafter) : new BaseSlot(inventory, index, x, y);
        }
        return slot;
    }

    private boolean mergeItemStacks(ItemStack itemStack, SlotType slotType, boolean reverse) {
        if (slotType == SlotType.SLOT_SPECIFICITEM) {
            for (SlotDefinition definition : this.factory.getSlotRangesMap().keySet()) {
                if (!slotType.equals((Object)definition.getType()) || !this.mergeItemStacks(itemStack, definition, reverse)) continue;
                return true;
            }
            return false;
        }
        return this.mergeItemStacks(itemStack, new SlotDefinition(slotType, new ItemStack[0]), reverse);
    }

    private boolean mergeItemStacks(ItemStack itemStack, SlotDefinition slotDefinition, boolean reverse) {
        SlotRanges ranges = this.factory.getSlotRangesMap().get(slotDefinition);
        if (ranges == null) {
            return false;
        }
        SlotType slotType = slotDefinition.getType();
        if (itemStack.func_77973_b() != null && slotType == SlotType.SLOT_SPECIFICITEM && !slotDefinition.itemStackMatches(itemStack)) {
            return false;
        }
        for (Range<Integer> r : ranges.asRanges()) {
            Integer start = (Integer)r.lowerEndpoint();
            int end = (Integer)r.upperEndpoint();
            if (!this.func_75135_a(itemStack, start, end, reverse)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            itemstack = origStack.func_77946_l();
            if (this.factory.isSpecificItemSlot(index)) {
                if (!this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, true) && !this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false)) {
                    return null;
                }
                slot.func_75220_a(origStack, itemstack);
            } else if (this.factory.isOutputSlot(index) || this.factory.isInputSlot(index) || this.factory.isContainerSlot(index)) {
                if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, true) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false))) {
                    return null;
                }
                slot.func_75220_a(origStack, itemstack);
            } else {
                if (this.factory.isGhostSlot(index) || this.factory.isGhostOutputSlot(index)) {
                    return null;
                }
                if (this.factory.isPlayerInventorySlot(index)) {
                    if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotType.SLOT_INPUT, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false))) {
                        return null;
                    }
                } else if (this.factory.isPlayerHotbarSlot(index)) {
                    if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotType.SLOT_INPUT, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, false))) {
                        return null;
                    }
                } else {
                    Logging.log("Weird slot at index: " + index);
                }
            }
            if (origStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (origStack.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, origStack);
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        ItemStack itemstack1;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reversOrder) {
            checkIndex = toIndex - 1;
        }
        if (par1ItemStack.func_77985_e()) {
            while (par1ItemStack.field_77994_a > 0 && (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 != null && itemstack1.func_77973_b() == par1ItemStack.func_77973_b() && (!par1ItemStack.func_77981_g() || par1ItemStack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack)) {
                    int mergedSize = itemstack1.field_77994_a + par1ItemStack.field_77994_a;
                    int maxStackSize = Math.min(par1ItemStack.func_77976_d(), slot.func_75219_a());
                    if (mergedSize <= maxStackSize) {
                        par1ItemStack.field_77994_a = 0;
                        itemstack1.field_77994_a = mergedSize;
                        slot.func_75218_e();
                        result = true;
                    } else if (itemstack1.field_77994_a < maxStackSize) {
                        par1ItemStack.field_77994_a -= maxStackSize - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = maxStackSize;
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (par1ItemStack.field_77994_a > 0) {
            checkIndex = reversOrder ? toIndex - 1 : fromIndex;
            while (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 == null && slot.func_75214_a(par1ItemStack)) {
                    ItemStack in = par1ItemStack.func_77946_l();
                    in.field_77994_a = Math.min(in.field_77994_a, slot.func_75219_a());
                    slot.func_75215_d(in);
                    slot.func_75218_e();
                    par1ItemStack.field_77994_a = in.field_77994_a >= par1ItemStack.field_77994_a ? 0 : (par1ItemStack.field_77994_a -= in.field_77994_a);
                    result = true;
                    break;
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }

    public ItemStack func_75144_a(int index, int button, int mode, EntityPlayer player) {
        Slot slot;
        if (this.factory.isGhostSlot(index) && (slot = this.func_75139_a(index)).func_75216_d()) {
            slot.func_75215_d(null);
        }
        return super.func_75144_a(index, button, mode, player);
    }
}

