/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.red;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoCacti;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceCanyon;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainCanyon;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeCanyon
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainCanyon(true, 35.0f, 160.0f, 60.0f, 40.0f, 69.0f);
    private SurfaceBase surface = new SurfaceCanyon((Block)Blocks.field_150354_m, (Block)Blocks.field_150354_m, 1, 0);

    public RealisticBiomeCanyon() {
        super(0, RWGBiomes.baseHotPlains, RealisticBiomeBase.coastDunes, RWGBiomes.baseRiverOasis);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        int z52;
        int k10;
        int j6;
        int b1;
        for (int l = 0; l < 1; ++l) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 >= 70) continue;
            new WorldGenBlockBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        if (river > 0.8f) {
            for (b1 = 0; b1 < 10; ++b1) {
                j6 = chunkX + rand.nextInt(16) + 8;
                k10 = chunkY + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10);
                WorldGenShrub worldgenerator = new WorldGenShrub(0, 0);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
        } else {
            for (b1 = 0; b1 < 5; ++b1) {
                j6 = chunkX + rand.nextInt(16) + 8;
                k10 = chunkY + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10);
                WorldGenShrub worldgenerator = new WorldGenShrub(0, 0);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            if (rand.nextInt(3) == 0) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
            }
            if (rand.nextInt(28) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            for (int i15 = 0; i15 < 5; ++i15) {
                int i17 = chunkX + rand.nextInt(16) + 8;
                int i20 = rand.nextInt(160);
                int l22 = chunkY + rand.nextInt(16) + 8;
                new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
            }
            for (int k18 = 0; k18 < 25; ++k18) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                new DecoCacti(true).func_76484_a(world, rand, k21, j23, k24);
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

