/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.ocean;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.map.MapVolcano;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceIslandMountainStone;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;
import rwg.world.ChunkManagerRealistic;

public class RealisticBiomeIslandTropical
extends RealisticBiomeBase {
    private SurfaceBase surface = new SurfaceIslandMountainStone((Block)Blocks.field_150349_c, Blocks.field_150346_d, 67, (Block)Blocks.field_150354_m, 0.0f);

    public RealisticBiomeIslandTropical() {
        super(0, RWGBiomes.baseOceanWet);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
    }

    @Override
    public void rMapGen(Block[] blocks, byte[] metadata, World world, ChunkManagerRealistic cmr, Random mapRand, int baseX, int baseY, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float[] noise) {
        float river;
        if (baseX % 4 == 0 && baseY % 4 == 0 && mapRand.nextInt(6) == 0 && (river = cmr.getRiverStrength(baseX * 16, baseY * 16) + 1.0f) > 0.98f && cmr.isBorderlessAt(baseX * 16, baseY * 16) && cmr.getNoiseWithRiverOceanAt(baseX * 16, baseY * 16, river, cmr.getOceanValue(baseX * 16, baseY * 16)) > 110.0f) {
            long i1 = mapRand.nextLong() / 2L * 2L + 1L;
            long j1 = mapRand.nextLong() / 2L * 2L + 1L;
            mapRand.setSeed((long)chunkX * i1 + (long)chunkY * j1 ^ world.func_72905_C());
            MapVolcano.build(blocks, metadata, world, mapRand, baseX, baseY, chunkX, chunkY, perlin, cell, noise);
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        float st = 15.0f - (cell.noise((double)x / 500.0, (double)y / 500.0, 1.0) * 42.0f + perlin.noise2((float)x / 30.0f, (float)y / 30.0f) * 2.0f);
        float h = st = st < 0.0f ? 0.0f : st;
        h = h < 0.0f ? 0.0f : h;
        if ((h += h * 0.4f * (h * 0.4f * 2.0f)) > 10.0f) {
            float d2 = (h - 10.0f) / 1.5f > 30.0f ? 30.0f : (h - 10.0f) / 1.5f;
            h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
        }
        h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * 3.0f;
        return 55.0f + (h += perlin.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f) * border;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

