/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.netmonitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.items.netmonitor.NetworkMonitorConfiguration;
import mcjty.rftools.items.netmonitor.PacketConnectedBlocksReady;
import mcjty.rftools.varia.EnergyTools;
import mcjty.varia.Coordinate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketGetConnectedBlocks
implements IMessage,
IMessageHandler<PacketGetConnectedBlocks, PacketConnectedBlocksReady> {
    private int x;
    private int y;
    private int z;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public PacketGetConnectedBlocks() {
    }

    public PacketGetConnectedBlocks(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketConnectedBlocksReady onMessage(PacketGetConnectedBlocks message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Map<Coordinate, BlockInfo> connectedBlocks = new HashMap<Coordinate, BlockInfo>();
        this.findConnectedBlocks(connectedBlocks, player.field_70170_p, message.x, message.y, message.z);
        if (connectedBlocks.size() > NetworkMonitorConfiguration.maximumBlocks) {
            connectedBlocks = this.compactConnectedBlocks(connectedBlocks, message.x, message.y, message.z, NetworkMonitorConfiguration.maximumBlocks);
        }
        int minx = 300000000;
        int miny = 300000000;
        int minz = 300000000;
        for (Coordinate coordinate : connectedBlocks.keySet()) {
            minx = Math.min(minx, coordinate.getX());
            miny = Math.min(miny, coordinate.getY());
            minz = Math.min(minz, coordinate.getZ());
        }
        return new PacketConnectedBlocksReady(connectedBlocks, minx, miny, minz);
    }

    private Map<Coordinate, BlockInfo> compactConnectedBlocks(Map<Coordinate, BlockInfo> old, final int x, final int y, final int z, int max) {
        ArrayList<Coordinate> list = new ArrayList<Coordinate>(old.keySet());
        Collections.sort(list, new Comparator<Coordinate>(){

            @Override
            public int compare(Coordinate o1, Coordinate o2) {
                double sqdist2;
                double sqdist1 = this.calcDist(o1);
                if (sqdist1 < (sqdist2 = (double)this.calcDist(o2))) {
                    return -1;
                }
                if (sqdist1 > sqdist2) {
                    return 1;
                }
                return 0;
            }

            private int calcDist(Coordinate o1) {
                return (o1.getX() - x) * (o1.getX() - x) + (o1.getY() - y) * (o1.getY() - y) + (o1.getZ() - z) * (o1.getZ() - z);
            }
        });
        HashMap<Coordinate, BlockInfo> connectedBlocks = new HashMap<Coordinate, BlockInfo>();
        for (Coordinate coordinate : list) {
            connectedBlocks.put(coordinate, old.get(coordinate));
            if (--max > 0) continue;
            break;
        }
        return connectedBlocks;
    }

    private void findConnectedBlocks(Map<Coordinate, BlockInfo> connectedBlocks, World world, int x, int y, int z) {
        if (y < 0 || y >= world.func_72800_K()) {
            return;
        }
        Coordinate c = new Coordinate(x, y, z);
        if (connectedBlocks.containsKey(c)) {
            return;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && EnergyTools.isEnergyTE(tileEntity)) {
            connectedBlocks.put(c, new BlockInfo(tileEntity, c));
            this.findConnectedBlocks(connectedBlocks, world, x + 1, y, z);
            this.findConnectedBlocks(connectedBlocks, world, x - 1, y, z);
            this.findConnectedBlocks(connectedBlocks, world, x, y - 1, z);
            this.findConnectedBlocks(connectedBlocks, world, x, y + 1, z);
            this.findConnectedBlocks(connectedBlocks, world, x, y, z - 1);
            this.findConnectedBlocks(connectedBlocks, world, x, y, z + 1);
        }
    }
}

