/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.dimension.world.types.TerrainType;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.types.IDimletType;
import mcjty.varia.BlockMeta;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class FeatureDimletType
implements IDimletType {
    private static final String CATEGORY_TYPE = "type_feature";
    private static int rarity = 0;
    private static int baseCreationCost = 100;
    private static int baseMaintainCost = 1;
    private static int baseTickCost = 1;
    private static FactorCosts[] factors = new FactorCosts[4];

    @Override
    public String getName() {
        return "Feature";
    }

    @Override
    public String getOpcode() {
        return "f";
    }

    @Override
    public String getTextureName() {
        return "featureDimlet";
    }

    @Override
    public void setupFromConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_TYPE, "Settings for the feature dimlet type");
        rarity = cfg.get(CATEGORY_TYPE, "rarity", rarity, "Default rarity for this dimlet type").getInt();
        baseCreationCost = cfg.get(CATEGORY_TYPE, "creation.cost", baseCreationCost, "Dimlet creation cost (how much power this dimlets adds during creation time of a dimension)").getInt();
        baseMaintainCost = cfg.get(CATEGORY_TYPE, "maintenance.cost", baseMaintainCost, "Dimlet maintenance cost (how much power this dimlet will use up to keep the dimension running)").getInt();
        baseTickCost = cfg.get(CATEGORY_TYPE, "tick.cost", baseTickCost, "Dimlet tick cost (how long it takes to make a dimension with this dimlet in it)").getInt();
        String[] desc = new String[]{"lowest class", "low class", "medium class", "high class"};
        for (int i = 0; i < 4; ++i) {
            FactorCosts fc = factors[i];
            fc.materialCreationCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.creation.factor." + i, (double)fc.materialCreationCostFactor, "The cost factor for a material dimlet modifier when used in combination with a feature of " + desc[i]).getDouble();
            fc.liquidCreationCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.creation.factor." + i, (double)fc.liquidCreationCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with a feature of " + desc[i]).getDouble();
            fc.materialMaintenanceCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.maintenance.factor." + i, (double)fc.materialMaintenanceCostFactor, "The cost factor for a material dimlet modifier when used in combination with a feature of " + desc[i]).getDouble();
            fc.liquidMaintenanceCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.maintenance.factor." + i, (double)fc.liquidMaintenanceCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with a feature of " + desc[i]).getDouble();
            fc.materialTickCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.tick.factor." + i, (double)fc.materialTickCostFactor, "The cost factor for a material dimlet modifier when used in combination with a feature of " + desc[i]).getDouble();
            fc.liquidTickCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.tick.factor." + i, (double)fc.liquidTickCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with a feature of " + desc[i]).getDouble();
        }
    }

    @Override
    public int getRarity() {
        return rarity;
    }

    @Override
    public int getCreationCost() {
        return baseCreationCost;
    }

    @Override
    public int getMaintenanceCost() {
        return baseMaintainCost;
    }

    @Override
    public int getTickCost() {
        return baseTickCost;
    }

    @Override
    public boolean isModifier() {
        return false;
    }

    @Override
    public boolean isModifiedBy(DimletType type) {
        return type == DimletType.DIMLET_MATERIAL || type == DimletType.DIMLET_LIQUID;
    }

    @Override
    public float getModifierCreateCostFactor(DimletType modifierType, DimletKey key) {
        FeatureType featureType = DimletObjectMapping.idToFeatureType.get(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return FeatureDimletType.factors[featureType.getMaterialClass()].materialCreationCostFactor;
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return FeatureDimletType.factors[featureType.getLiquidClass()].liquidCreationCostFactor;
        }
        return 1.0f;
    }

    @Override
    public float getModifierMaintainCostFactor(DimletType modifierType, DimletKey key) {
        FeatureType featureType = DimletObjectMapping.idToFeatureType.get(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return FeatureDimletType.factors[featureType.getMaterialClass()].materialMaintenanceCostFactor;
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return FeatureDimletType.factors[featureType.getLiquidClass()].liquidMaintenanceCostFactor;
        }
        return 1.0f;
    }

    @Override
    public float getModifierTickCostFactor(DimletType modifierType, DimletKey key) {
        FeatureType featureType = DimletObjectMapping.idToFeatureType.get(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return FeatureDimletType.factors[featureType.getMaterialClass()].materialTickCostFactor;
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return FeatureDimletType.factors[featureType.getLiquidClass()].liquidTickCostFactor;
        }
        return 1.0f;
    }

    @Override
    public boolean isInjectable() {
        return false;
    }

    @Override
    public void inject(DimletKey key, DimensionInformation dimensionInformation) {
    }

    @Override
    public void constructDimension(List<Pair<DimletKey, List<DimletKey>>> dimlets, Random random, DimensionInformation dimensionInformation) {
        TerrainType terrainType = dimensionInformation.getTerrainType();
        Set<FeatureType> featureTypes = dimensionInformation.getFeatureTypes();
        if ((dimlets = DimensionInformation.extractType(DimletType.DIMLET_FEATURE, dimlets)).isEmpty()) {
            while (random.nextFloat() < DimletConfiguration.randomFeatureChance) {
                DimletKey key = DimletRandomizer.getRandomFeature(random, false);
                FeatureType featureType = DimletObjectMapping.idToFeatureType.get(key);
                if (featureTypes.contains((Object)featureType) || !featureType.isTerrainSupported(terrainType)) continue;
                dimensionInformation.updateCostFactor(key);
                featureTypes.add(featureType);
                List modifiers = Collections.emptyList();
                dimlets.add((Pair<DimletKey, List<DimletKey>>)Pair.of((Object)key, modifiers));
            }
        }
        HashMap<FeatureType, List<DimletKey>> modifiersForFeature = new HashMap<FeatureType, List<DimletKey>>();
        for (Pair<DimletKey, List<DimletKey>> dimlet : dimlets) {
            DimletKey key = (DimletKey)dimlet.getLeft();
            FeatureType featureType = DimletObjectMapping.idToFeatureType.get(key);
            featureTypes.add(featureType);
            modifiersForFeature.put(featureType, (List<DimletKey>)dimlet.getRight());
        }
        dimensionInformation.setFluidsForLakes(this.getRandomFluidArray(random, dimensionInformation, featureTypes, modifiersForFeature, FeatureType.FEATURE_LAKES, true));
        dimensionInformation.setExtraOregen(this.getRandomBlockArray(random, featureTypes, modifiersForFeature, FeatureType.FEATURE_OREGEN, true));
        dimensionInformation.setTendrilBlock(dimensionInformation.getFeatureBlock(random, modifiersForFeature, FeatureType.FEATURE_TENDRILS));
        dimensionInformation.setSphereBlocks(this.getRandomBlockArray(random, featureTypes, modifiersForFeature, FeatureType.FEATURE_ORBS, false));
        dimensionInformation.setPyramidBlocks(this.getRandomBlockArray(random, featureTypes, modifiersForFeature, FeatureType.FEATURE_PYRAMIDS, false));
        dimensionInformation.setHugeSphereBlocks(this.getRandomBlockArray(random, featureTypes, modifiersForFeature, FeatureType.FEATURE_HUGEORBS, false));
        dimensionInformation.setLiquidSphereBlocks(this.getRandomBlockArray(random, featureTypes, modifiersForFeature, FeatureType.FEATURE_LIQUIDORBS, false));
        dimensionInformation.setLiquidSphereFluids(this.getRandomFluidArray(random, dimensionInformation, featureTypes, modifiersForFeature, FeatureType.FEATURE_LIQUIDORBS, false));
        dimensionInformation.setHugeLiquidSphereBlocks(this.getRandomBlockArray(random, featureTypes, modifiersForFeature, FeatureType.FEATURE_HUGELIQUIDORBS, false));
        dimensionInformation.setHugeLiquidSphereFluids(this.getRandomFluidArray(random, dimensionInformation, featureTypes, modifiersForFeature, FeatureType.FEATURE_HUGELIQUIDORBS, false));
        dimensionInformation.setCanyonBlock(dimensionInformation.getFeatureBlock(random, modifiersForFeature, FeatureType.FEATURE_CANYONS));
    }

    private Block[] getRandomFluidArray(Random random, DimensionInformation dimensionInformation, Set<FeatureType> featureTypes, Map<FeatureType, List<DimletKey>> modifiersForFeature, FeatureType t, boolean allowEmpty) {
        Block[] fluidsForLakes;
        if (featureTypes.contains((Object)t)) {
            ArrayList<BlockMeta> blocks = new ArrayList<BlockMeta>();
            ArrayList<Block> fluids = new ArrayList<Block>();
            DimensionInformation.getMaterialAndFluidModifiers(modifiersForFeature.get((Object)t), blocks, fluids);
            if (fluids.isEmpty()) {
                while (random.nextFloat() < DimletConfiguration.randomLakeFluidChance) {
                    DimletKey key = DimletRandomizer.getRandomFluidBlock(random, true);
                    dimensionInformation.updateCostFactor(key);
                    fluids.add(DimletObjectMapping.idToFluid.get(key));
                }
            } else if (fluids.size() == 1 && fluids.get(0) == null) {
                fluids.clear();
            }
            fluidsForLakes = fluids.toArray(new Block[fluids.size()]);
            for (int i = 0; i < fluidsForLakes.length; ++i) {
                if (fluidsForLakes[i] != null) continue;
                fluidsForLakes[i] = Blocks.field_150355_j;
            }
        } else {
            fluidsForLakes = new Block[]{};
        }
        if (allowEmpty || fluidsForLakes.length > 0) {
            return fluidsForLakes;
        }
        return new Block[]{Blocks.field_150355_j};
    }

    private BlockMeta[] getRandomBlockArray(Random random, Set<FeatureType> featureTypes, Map<FeatureType, List<DimletKey>> modifiersForFeature, FeatureType t, boolean allowEmpty) {
        BlockMeta[] blockArray;
        if (featureTypes.contains((Object)t)) {
            ArrayList<BlockMeta> blocks = new ArrayList<BlockMeta>();
            ArrayList<Block> fluids = new ArrayList<Block>();
            DimensionInformation.getMaterialAndFluidModifiers(modifiersForFeature.get((Object)t), blocks, fluids);
            if (blocks.isEmpty()) {
                float chance = 1.1f;
                while (random.nextFloat() < chance) {
                    DimletKey key = DimletRandomizer.getRandomMaterialBlock(random, true);
                    BlockMeta bm = DimletObjectMapping.idToBlock.get(key);
                    if (bm == null) continue;
                    blocks.add(bm);
                    chance *= 0.8f;
                }
            }
            blockArray = blocks.toArray(new BlockMeta[blocks.size()]);
            for (int i = 0; i < blockArray.length; ++i) {
                if (blockArray[i] != null) continue;
                blockArray[i] = BlockMeta.STONE;
            }
        } else {
            blockArray = new BlockMeta[]{};
        }
        if (allowEmpty || blockArray.length > 0) {
            return blockArray;
        }
        return new BlockMeta[]{BlockMeta.STONE};
    }

    @Override
    public String[] getInformation() {
        return new String[]{"This affects various features of the dimension.", "Some of these features need material or liquid modifiers", "which you have to put in front of this feature."};
    }

    @Override
    public DimletKey attemptDimletCrafting(ItemStack stackController, ItemStack stackMemory, ItemStack stackEnergy, ItemStack stackEssence) {
        return null;
    }

    static {
        FeatureDimletType.factors[0] = new FactorCosts(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        FeatureDimletType.factors[1] = new FactorCosts(1.4f, 1.4f, 1.3f, 1.4f, 1.4f, 1.3f);
        FeatureDimletType.factors[2] = new FactorCosts(1.8f, 1.8f, 1.5f, 1.8f, 1.8f, 1.5f);
        FeatureDimletType.factors[3] = new FactorCosts(2.5f, 2.5f, 1.7f, 2.5f, 2.5f, 1.7f);
    }

    private static class FactorCosts {
        float materialCreationCostFactor;
        float materialMaintenanceCostFactor;
        float materialTickCostFactor;
        float liquidCreationCostFactor;
        float liquidMaintenanceCostFactor;
        float liquidTickCostFactor;

        private FactorCosts(float materialCreationCostFactor, float materialMaintenanceCostFactor, float materialTickCostFactor, float liquidCreationCostFactor, float liquidMaintenanceCostFactor, float liquidTickCostFactor) {
            this.materialCreationCostFactor = materialCreationCostFactor;
            this.materialMaintenanceCostFactor = materialMaintenanceCostFactor;
            this.materialTickCostFactor = materialTickCostFactor;
            this.liquidCreationCostFactor = liquidCreationCostFactor;
            this.liquidMaintenanceCostFactor = liquidMaintenanceCostFactor;
            this.liquidTickCostFactor = liquidTickCostFactor;
        }
    }
}

