/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.dimension.description.MobDescriptor;
import mcjty.varia.Logging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;

public class MobConfiguration {
    public static final Map<String, MobDescriptor> mobClasses = new HashMap<String, MobDescriptor>();

    public static void readMobConfig(Configuration cfg) {
        MobConfiguration.initMobItem(cfg, null, "Default", 1, 1, 1, 1);
        MobConfiguration.initMobItem(cfg, EntityZombie.class, "Zombie", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, EntitySkeleton.class, "Skeleton", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, EntityEnderman.class, "Enderman", 20, 2, 4, 20);
        MobConfiguration.initMobItem(cfg, EntityBlaze.class, "Blaze", 20, 2, 4, 20);
        MobConfiguration.initMobItem(cfg, EntityCreeper.class, "Creeper", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, EntityCaveSpider.class, "Cave Spider", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, EntityGhast.class, "Ghast", 20, 2, 4, 20);
        MobConfiguration.initMobItem(cfg, EntityIronGolem.class, "Iron Golem", 20, 1, 2, 6);
        MobConfiguration.initMobItem(cfg, EntityMagmaCube.class, "Magma Cube", 50, 2, 4, 30);
        MobConfiguration.initMobItem(cfg, EntityPigZombie.class, "Zombie Pigman", 20, 2, 4, 10);
        MobConfiguration.initMobItem(cfg, EntitySlime.class, "Slime", 50, 2, 4, 30);
        MobConfiguration.initMobItem(cfg, EntitySnowman.class, "Snowman", 50, 2, 4, 30);
        MobConfiguration.initMobItem(cfg, EntitySpider.class, "Spider", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, EntityWitch.class, "Witch", 10, 1, 1, 20);
        MobConfiguration.initMobItem(cfg, EntityBat.class, "Bat", 10, 8, 8, 20);
        MobConfiguration.initMobItem(cfg, EntityChicken.class, "Chicken", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, EntityCow.class, "Cow", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, EntityHorse.class, "Horse", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, EntityMooshroom.class, "Mooshroom", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, EntityOcelot.class, "Ocelot", 5, 2, 3, 20);
        MobConfiguration.initMobItem(cfg, EntityPig.class, "Pig", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, EntitySheep.class, "Sheep", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, EntitySquid.class, "Squid", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, EntityWolf.class, "Wolf", 10, 3, 4, 20);
        MobConfiguration.initMobItem(cfg, EntityVillager.class, "Villager", 10, 3, 4, 20);
        MobConfiguration.initMobItem(cfg, EntityWither.class, "Wither", 5, 1, 2, 5);
        MobConfiguration.initMobItem(cfg, EntityDragon.class, "Dragon", 4, 1, 2, 4);
        MobConfiguration.readModdedMobConfig(cfg);
        SpawnerConfiguration.readMobSpawnAmountConfig(cfg);
        ConfigCategory category = cfg.getCategory("mobspawns");
        for (Map.Entry entry : category.entrySet()) {
            String name = (String)entry.getKey();
            String[] splitted = StringUtils.split((String)name, (String)".");
            if (mobClasses.containsKey(splitted[0])) continue;
            MobConfiguration.registerCustomMobItem(category, splitted[0]);
            SpawnerConfiguration.addMobSpawnAmount(cfg, splitted[0], 0, Blocks.field_150346_d, 0, 100.0f);
            SpawnerConfiguration.addMobSpawnAmount(cfg, splitted[0], 1, Blocks.field_150346_d, 0, 100.0f);
            SpawnerConfiguration.addMobSpawnAmount(cfg, splitted[0], 2, "living", 0, 100.0f);
            SpawnerConfiguration.addMobSpawnRF(cfg, splitted[0], 1000);
        }
    }

    public static void readModdedMobConfig(Configuration cfg) {
        MobConfiguration.initModdedMobItem(cfg, "Blizz", "Blizz", 20, 2, 4, 20);
        MobConfiguration.initModdedMobItem(cfg, "Thaumcraft.Wisp", "Wisp", 20, 2, 4, 10);
        SpawnerConfiguration.readModdedMobSpawnAmountConfig(cfg);
    }

    private static void registerCustomMobItem(ConfigCategory category, String name) {
        Property entityNameProperty = MobConfiguration.checkProperty(category, name, "entityname");
        if (entityNameProperty == null) {
            return;
        }
        String entityName = entityNameProperty.getString();
        Property chanceProperty = MobConfiguration.checkProperty(category, name, "chance");
        if (chanceProperty == null) {
            return;
        }
        int chance = chanceProperty.getInt();
        Property maxentityProperty = MobConfiguration.checkProperty(category, name, "maxentity");
        if (maxentityProperty == null) {
            return;
        }
        int maxentity = chanceProperty.getInt();
        Property maxgroupProperty = MobConfiguration.checkProperty(category, name, "maxgroup");
        if (maxgroupProperty == null) {
            return;
        }
        int maxgroup = chanceProperty.getInt();
        Property mingroupProperty = MobConfiguration.checkProperty(category, name, "mingroup");
        if (mingroupProperty == null) {
            return;
        }
        int mingroup = chanceProperty.getInt();
        MobConfiguration.initModdedMobItem(null, entityName, name, chance, mingroup, maxgroup, maxentity);
    }

    private static Property checkProperty(ConfigCategory category, String name, String propname) {
        Property entityNameProperty = category.get(name + "." + propname);
        if (entityNameProperty == null) {
            Logging.logError((String)("Invalid custom mob item: '" + propname + "' property is missing!"));
            return null;
        }
        return entityNameProperty;
    }

    private static void initModdedMobItem(Configuration cfg, String entityName, String name, int chance, int mingroup, int maxgroup, int maxentity) {
        Class clazz = (Class)EntityList.field_75625_b.get(entityName);
        if (cfg != null) {
            chance = cfg.get("mobspawns", name + ".chance", chance).getInt();
            mingroup = cfg.get("mobspawns", name + ".mingroup", mingroup).getInt();
            maxgroup = cfg.get("mobspawns", name + ".maxgroup", maxgroup).getInt();
            maxentity = cfg.get("mobspawns", name + ".maxentity", maxentity).getInt();
        }
        mobClasses.put(name, new MobDescriptor(entityName, clazz, chance, mingroup, maxgroup, maxentity));
    }

    private static void initMobItem(Configuration cfg, Class<? extends EntityLiving> entity, String name, int chance, int mingroup, int maxgroup, int maxentity) {
        if (cfg != null) {
            chance = cfg.get("mobspawns", name + ".chance", chance).getInt();
            mingroup = cfg.get("mobspawns", name + ".mingroup", mingroup).getInt();
            maxgroup = cfg.get("mobspawns", name + ".maxgroup", maxgroup).getInt();
            maxentity = cfg.get("mobspawns", name + ".maxentity", maxentity).getInt();
        }
        mobClasses.put(name, new MobDescriptor(null, entity, chance, mingroup, maxgroup, maxentity));
    }
}

