/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.mapgen;

import java.util.Random;
import mcjty.rftools.dimension.world.GenericChunkProvider;
import mcjty.varia.BlockMeta;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;

public class MapGenPyramids {
    private final GenericChunkProvider provider;

    public MapGenPyramids(GenericChunkProvider provider) {
        this.provider = provider;
    }

    public void generate(World world, int chunkX, int chunkZ, Block[] ablock, byte[] ameta) {
        BlockMeta[] blocks = this.provider.dimensionInformation.getPyramidBlocks();
        Random random = new Random((world.func_72905_C() + (long)chunkX) * 1133L + (long)(chunkZ * 37) + 77L);
        random.nextFloat();
        if (random.nextFloat() < 0.05f) {
            int x = 8;
            int z = 8;
            int y = this.getBestY(ablock, 8, 8);
            if (y < 10 || y > 230) {
                return;
            }
            BlockMeta block = BlockMeta.STONE;
            if (blocks.length > 1) {
                block = blocks[random.nextInt(blocks.length)];
            } else if (blocks.length == 1) {
                block = blocks[0];
            }
            for (int i = 7; i >= 0; --i) {
                for (int dx = -i; dx <= i - 1; ++dx) {
                    for (int dz = -i; dz <= i - 1; ++dz) {
                        int index = ((x + dx) * 16 + (z + dz)) * 256;
                        ablock[index + y] = block.getBlock();
                        ameta[index + y] = block.getMeta();
                    }
                }
                ++y;
            }
        }
    }

    private int getBestY(Block[] ablock, int x, int z) {
        int y = this.findTopSolid(ablock, x, z);
        int y1 = this.findTopSolid(ablock, x - 7, z - 7);
        if (y1 < y) {
            y = y1;
        }
        if ((y1 = this.findTopSolid(ablock, x + 7, z - 7)) < y) {
            y = y1;
        }
        if ((y1 = this.findTopSolid(ablock, x - 7, z + 7)) < y) {
            y = y1;
        }
        if ((y1 = this.findTopSolid(ablock, x + 7, z + 7)) < y) {
            y = y1;
        }
        return y;
    }

    private int findTopSolid(Block[] ablock, int x, int z) {
        int y;
        int index = (x * 16 + z) * 256;
        for (y = 255; y >= 5 && (ablock[index + y] == null || ablock[index + y].func_149688_o() == Material.field_151579_a); --y) {
        }
        return y;
    }
}

