/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import io.netty.buffer.ByteBuf;
import mcjty.network.NetworkTools;
import mcjty.rftools.blocks.teleporter.TeleportDestination;

public class TeleportDestinationClientInfo
extends TeleportDestination
implements Comparable<TeleportDestinationClientInfo> {
    private String dimensionName = "";
    private boolean favorite = false;

    public TeleportDestinationClientInfo(TeleportDestinationClientInfo clientInfo) {
        super(clientInfo.getCoordinate(), clientInfo.getDimension());
        this.dimensionName = clientInfo.dimensionName;
        this.favorite = clientInfo.favorite;
    }

    public TeleportDestinationClientInfo(ByteBuf buf) {
        super(buf);
        this.setDimensionName(NetworkTools.readString((ByteBuf)buf));
        this.setFavorite(buf.readBoolean());
    }

    public TeleportDestinationClientInfo(TeleportDestination destination) {
        super(destination.getCoordinate(), destination.getDimension());
        this.setName(destination.getName());
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkTools.writeString((ByteBuf)buf, (String)this.getDimensionName());
        buf.writeBoolean(this.favorite);
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    @Override
    public int compareTo(TeleportDestinationClientInfo o) {
        if (this.getDimension() < o.getDimension()) {
            return -1;
        }
        if (this.getDimension() > o.getDimension()) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TeleportDestinationClientInfo that = (TeleportDestinationClientInfo)o;
        if (this.favorite != that.favorite) {
            return false;
        }
        return !(this.dimensionName != null ? !this.dimensionName.equals(that.dimensionName) : that.dimensionName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dimensionName != null ? this.dimensionName.hashCode() : 0);
        result = 31 * result + (this.favorite ? 1 : 0);
        return result;
    }
}

