/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.entity.GenericTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.varia.BlockTools;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import net.minecraft.nbt.NBTTagCompound;

public class SimpleDialerTileEntity
extends GenericTileEntity {
    GlobalCoordinate transmitter;
    Integer receiver;
    private int prevValue = -1;
    private boolean onceMode = false;

    public boolean canUpdate() {
        return false;
    }

    protected void checkStateServer() {
        int newvalue;
        super.checkStateServer();
        if (this.transmitter == null) {
            return;
        }
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int n = newvalue = BlockTools.getRedstoneSignalIn((int)meta) ? 1 : 0;
        if (newvalue != this.prevValue) {
            this.prevValue = newvalue;
            if (newvalue == 1) {
                int dial;
                GlobalCoordinate gc;
                TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
                Coordinate coordinate = null;
                int dim = 0;
                if (this.receiver != null && (gc = destinations.getCoordinateForId(this.receiver)) != null) {
                    coordinate = gc.getCoordinate();
                    dim = gc.getDimension();
                }
                if ((dial = TeleportationTools.dial(this.field_145850_b, null, null, this.transmitter.getCoordinate(), this.transmitter.getDimension(), coordinate, dim, this.onceMode)) != 0) {
                    // empty if block
                }
            }
        }
    }

    public boolean isOnceMode() {
        return this.onceMode;
    }

    public void setOnceMode(boolean onceMode) {
        this.onceMode = onceMode;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.transmitter = tagCompound.func_74764_b("transX") ? new GlobalCoordinate(new Coordinate(tagCompound.func_74762_e("transX"), tagCompound.func_74762_e("transY"), tagCompound.func_74762_e("transZ")), tagCompound.func_74762_e("transDim")) : null;
        this.receiver = tagCompound.func_74764_b("receiver") ? Integer.valueOf(tagCompound.func_74762_e("receiver")) : null;
        this.onceMode = tagCompound.func_74767_n("once");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.transmitter != null) {
            tagCompound.func_74768_a("transX", this.transmitter.getCoordinate().getX());
            tagCompound.func_74768_a("transY", this.transmitter.getCoordinate().getY());
            tagCompound.func_74768_a("transZ", this.transmitter.getCoordinate().getZ());
            tagCompound.func_74768_a("transDim", this.transmitter.getDimension());
        }
        if (this.receiver != null) {
            tagCompound.func_74768_a("receiver", this.receiver.intValue());
        }
        tagCompound.func_74757_a("once", this.onceMode);
    }
}

