/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import mcjty.rftools.blocks.storage.ModularStorageBlock;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.render.DefaultISBRH;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class ModularStorageRenderer
extends DefaultISBRH {
    private static final float OFFS = 0.005f;
    private static final float L = 0.19f;
    private static final float R = 0.25f;
    private static final float U = 0.32f;
    private static final float D = 0.82f;
    private static final DefaultISBRH.Quad[] quadsBar = new DefaultISBRH.Quad[]{new DefaultISBRH.Quad(new DefaultISBRH.Vt(0.25f, -0.005f, 0.68f), new DefaultISBRH.Vt(0.19f, -0.005f, 0.68f), new DefaultISBRH.Vt(0.19f, -0.005f, 0.18f), new DefaultISBRH.Vt(0.25f, -0.005f, 0.18f)), new DefaultISBRH.Quad(new DefaultISBRH.Vt(0.19f, 1.005f, 0.68f), new DefaultISBRH.Vt(0.25f, 1.005f, 0.68f), new DefaultISBRH.Vt(0.25f, 1.005f, 0.18f), new DefaultISBRH.Vt(0.19f, 1.005f, 0.18f)), new DefaultISBRH.Quad(new DefaultISBRH.Vt(0.81f, 0.32f, -0.005f), new DefaultISBRH.Vt(0.75f, 0.32f, -0.005f), new DefaultISBRH.Vt(0.75f, 0.82f, -0.005f), new DefaultISBRH.Vt(0.81f, 0.82f, -0.005f)), new DefaultISBRH.Quad(new DefaultISBRH.Vt(0.19f, 0.32f, 1.005f), new DefaultISBRH.Vt(0.25f, 0.32f, 1.005f), new DefaultISBRH.Vt(0.25f, 0.82f, 1.005f), new DefaultISBRH.Vt(0.19f, 0.82f, 1.005f)), new DefaultISBRH.Quad(new DefaultISBRH.Vt(-0.005f, 0.32f, 0.19f), new DefaultISBRH.Vt(-0.005f, 0.32f, 0.25f), new DefaultISBRH.Vt(-0.005f, 0.82f, 0.25f), new DefaultISBRH.Vt(-0.005f, 0.82f, 0.19f)), new DefaultISBRH.Quad(new DefaultISBRH.Vt(1.005f, 0.32f, 0.81f), new DefaultISBRH.Vt(1.005f, 0.32f, 0.75f), new DefaultISBRH.Vt(1.005f, 0.82f, 0.75f), new DefaultISBRH.Vt(1.005f, 0.82f, 0.81f))};

    public int getRenderId() {
        return ModularStorageBlock.RENDERID_MODULARSTORAGE;
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean rc = renderer.func_147784_q(block, x, y, z);
        if (rc) {
            ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)world.func_147438_o(x, y, z);
            int level = modularStorageTileEntity.getRenderLevel();
            if (level == -1) {
                return rc;
            }
            ForgeDirection front = ModularStorageSetup.modularStorageBlock.getOrientation(world.func_72805_g(x, y, z));
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78372_c((float)x, (float)y, (float)z);
            tessellator.func_78380_c(240);
            IIcon icon = ModularStorageSetup.modularStorageBlock.getOverlayIcon();
            int remoteId = modularStorageTileEntity.getRemoteId();
            float pct = (float)level / 7.0f;
            float u1 = icon.func_94209_e();
            float u2 = icon.func_94212_f();
            u2 = u1 + (u2 - u1) / 2.0f;
            float du = (u2 - u1) * (1.0f - pct);
            u1 += du;
            u2 += du;
            float v1 = icon.func_94206_g();
            float v2 = icon.func_94210_h();
            float dv = (v2 - v1) / 2.0f;
            v2 = v1 + dv / 8.0f;
            if (remoteId != 0) {
                v1 += dv;
                v2 += dv;
            }
            DefaultISBRH.Quad quad = quadsBar[front.ordinal()];
            tessellator.func_78374_a((double)quad.v1.x, (double)quad.v1.y, (double)quad.v1.z, (double)u1, (double)v1);
            tessellator.func_78374_a((double)quad.v2.x, (double)quad.v2.y, (double)quad.v2.z, (double)u1, (double)v2);
            tessellator.func_78374_a((double)quad.v3.x, (double)quad.v3.y, (double)quad.v3.z, (double)u2, (double)v2);
            tessellator.func_78374_a((double)quad.v4.x, (double)quad.v4.y, (double)quad.v4.z, (double)u2, (double)v1);
            tessellator.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        }
        return rc;
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

