/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import java.awt.Rectangle;
import mcjty.base.ModBase;
import mcjty.container.GenericGuiContainer;
import mcjty.entity.GenericTileEntity;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.LayoutHint;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.ToggleButton;
import mcjty.gui.widgets.Widget;
import mcjty.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spaceprojector.BuilderContainer;
import mcjty.rftools.blocks.spaceprojector.BuilderTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiBuilder
extends GenericGuiContainer<BuilderTileEntity> {
    public static final int BUILDER_WIDTH = 180;
    public static final int BUILDER_HEIGHT = 152;
    private EnergyBar energyBar;
    private ChoiceLabel modeChoice;
    private ImageChoiceLabel silentMode;
    private ImageChoiceLabel supportMode;
    private ImageChoiceLabel entityMode;
    private ImageChoiceLabel loopMode;
    private ToggleButton[] anchor = new ToggleButton[4];
    private String[] anchorLabels = new String[]{"O", "O", "O", "O"};
    private ChoiceLabel rotateButton;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/spaceprojector.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiBuilder(BuilderTileEntity builderTileEntity, BuilderContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)builderTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "builder");
        BuilderTileEntity.setCurrentRF((int)builderTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((BuilderTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        BuilderTileEntity cfr_ignored_0 = (BuilderTileEntity)this.tileEntity;
        this.energyBar.setValue(BuilderTileEntity.getCurrentRF());
        this.modeChoice = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{BuilderTileEntity.MODES[0], BuilderTileEntity.MODES[1], BuilderTileEntity.MODES[2], BuilderTileEntity.MODES[3]}).setTooltips(new String[]{"Set the building mode"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(48, 7, 45, 14))).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.updateMode();
            }
        });
        this.modeChoice.setChoice(BuilderTileEntity.MODES[((BuilderTileEntity)this.tileEntity).getMode()]);
        this.rotateButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"0", "90", "180", "270"}).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(130, 7, 40, 14))).setTooltips(new String[]{"Set the horizontal rotation angle"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.updateRotate();
            }
        });
        switch (((BuilderTileEntity)this.tileEntity).getRotate()) {
            case 0: {
                this.rotateButton.setChoice("0");
                break;
            }
            case 1: {
                this.rotateButton.setChoice("90");
                break;
            }
            case 2: {
                this.rotateButton.setChoice("180");
                break;
            }
            case 3: {
                this.rotateButton.setChoice("270");
            }
        }
        this.silentMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(48, 24, 16, 16))).setTooltips(new String[]{"Suppress the placement/breaking sound", "when moving blocks"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.setSilentMode();
            }
        });
        this.silentMode.addChoice("off", "Moving blocks make sound", guiElements, 176, 48);
        this.silentMode.addChoice("on", "Block sounds are muted", guiElements, 160, 48);
        this.silentMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).isSilent() ? 1 : 0);
        this.supportMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(66, 24, 16, 16))).setTooltips(new String[]{"Use supporting blocks when moving.", "Useful for liquids, gravel, ..."})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.setSupportMode();
            }
        });
        this.supportMode.addChoice("off", "Support mode is disabled", guiElements, 112, 48);
        this.supportMode.addChoice("on", "Support mode is enabled", guiElements, 96, 48);
        this.supportMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasSupportMode() ? 1 : 0);
        this.entityMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(48, 42, 16, 16))).setTooltips(new String[]{"Move entities"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.setEntityMode();
            }
        });
        this.entityMode.addChoice("off", "Entities are not moved", guiElements, 144, 48);
        this.entityMode.addChoice("on", "Entities are moved", guiElements, 128, 48);
        this.entityMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasEntityMode() ? 1 : 0);
        this.loopMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(66, 42, 16, 16))).setTooltips(new String[]{"Loop mode"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.setLoopMode();
            }
        });
        this.loopMode.addChoice("off", "Do a single run and stop", guiElements, 208, 48);
        this.loopMode.addChoice("on", "Keep running with redstone signal", guiElements, 192, 48);
        this.loopMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasLoopMode() ? 1 : 0);
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)this.modeChoice)).addChild((Widget)this.rotateButton)).addChild((Widget)this.silentMode)).addChild((Widget)this.supportMode)).addChild((Widget)this.entityMode)).addChild((Widget)this.loopMode);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        for (int y = 0; y <= 1; ++y) {
            for (int x = 0; x <= 1; ++x) {
                final int index = x + y * 2;
                this.anchor[index] = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setText(this.anchorLabels[index])).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(132 + x * 20, 24 + (1 - y) * 15, 18, 13))).setTooltips(new String[]{"Set the anchor where you want to", "place the blocks in front of the", "builder"});
                this.anchor[index].addButtonEvent(new ButtonEvent(){

                    public void buttonClicked(Widget parent) {
                        GuiBuilder.this.selectAnchor(index);
                    }
                });
                toplevel.addChild((Widget)this.anchor[index]);
            }
        }
        this.anchor[((BuilderTileEntity)this.tileEntity).getAnchor()].setPressed(true);
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((BuilderTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
    }

    private void setLoopMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setLoop", new Argument[]{new Argument("loop", this.loopMode.getCurrentChoiceIndex() == 1)});
    }

    private void setSilentMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setSilent", new Argument[]{new Argument("silent", this.silentMode.getCurrentChoiceIndex() == 1)});
    }

    private void setSupportMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setSupport", new Argument[]{new Argument("support", this.supportMode.getCurrentChoiceIndex() == 1)});
    }

    private void setEntityMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setEntities", new Argument[]{new Argument("entities", this.entityMode.getCurrentChoiceIndex() == 1)});
    }

    private void selectAnchor(int index) {
        for (int i = 0; i < this.anchor.length; ++i) {
            if (this.anchor[i].isPressed() == (i == index)) continue;
            this.anchor[i].setPressed(i == index);
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setAnchor", new Argument[]{new Argument("anchor", index)});
    }

    private void updateMode() {
        String currentChoice = this.modeChoice.getCurrentChoice();
        int mode = 0;
        for (int i = 0; i < BuilderTileEntity.MODES.length; ++i) {
            if (!currentChoice.equals(BuilderTileEntity.MODES[i])) continue;
            mode = i;
            break;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("mode", mode)});
    }

    private void updateRotate() {
        String choice = this.rotateButton.getCurrentChoice();
        int index = 0;
        if ("0".equals(choice)) {
            index = 0;
        } else if ("90".equals(choice)) {
            index = 1;
        } else if ("180".equals(choice)) {
            index = 2;
        } else if ("270".equals(choice)) {
            index = 3;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setRotate", new Argument[]{new Argument("rotate", index)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
        BuilderTileEntity cfr_ignored_0 = (BuilderTileEntity)this.tileEntity;
        this.energyBar.setValue(BuilderTileEntity.getCurrentRF());
        ((BuilderTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
    }
}

