/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import java.util.Map;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericTileEntity;
import mcjty.network.Argument;
import mcjty.rftools.blocks.security.SecurityChannels;
import mcjty.rftools.blocks.security.SecurityManagerContainer;
import mcjty.rftools.blocks.security.SecuritySetup;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class SecurityManagerTileEntity
extends GenericTileEntity
implements IInventory {
    public static final String CMD_SETCHANNELNAME = "setChannelName";
    public static final String CMD_SETMODE = "setMode";
    public static final String CMD_ADDPLAYER = "addPlayer";
    public static final String CMD_DELPLAYER = "delPlayer";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, SecurityManagerContainer.factory, 14);

    public boolean canUpdate() {
        return false;
    }

    private NBTTagCompound getOrCreateNBT(ItemStack cardStack) {
        NBTTagCompound tagCompound = cardStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            cardStack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    private void updateCard(ItemStack cardStack) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (cardStack == null) {
            return;
        }
        NBTTagCompound tagCompound = this.getOrCreateNBT(cardStack);
        if (!tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.field_145850_b);
            int id = securityChannels.newChannel();
            tagCompound.func_74768_a("channel", id);
            securityChannels.save(this.field_145850_b);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void updateLinkedCard() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack masterCard = this.inventoryHelper.getStackInSlot(0);
        if (masterCard == null) {
            return;
        }
        ItemStack linkerCard = this.inventoryHelper.getStackInSlot(1);
        if (linkerCard == null) {
            return;
        }
        NBTTagCompound masterNBT = masterCard.func_77978_p();
        if (masterNBT == null) {
            return;
        }
        NBTTagCompound linkerNBT = this.getOrCreateNBT(linkerCard);
        linkerNBT.func_74768_a("channel", masterNBT.func_74762_e("channel"));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void addPlayer(String player) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.field_145850_b);
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.addPlayer(player);
            securityChannels.save(this.field_145850_b);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void delPlayer(String player) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.field_145850_b);
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.delPlayer(player);
            securityChannels.save(this.field_145850_b);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void setWhiteListMode(boolean whitelist) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.field_145850_b);
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.setWhitelist(whitelist);
            securityChannels.save(this.field_145850_b);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void setChannelName(String name) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.field_145850_b);
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.setName(name);
            securityChannels.save(this.field_145850_b);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private NBTTagCompound getCardInfo() {
        ItemStack cardStack = this.inventoryHelper.getStackInSlot(0);
        if (cardStack == null) {
            return null;
        }
        return this.getOrCreateNBT(cardStack);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index == 0) {
            this.updateCard(stack);
            this.updateLinkedCard();
        } else if (index == 1) {
            this.updateLinkedCard();
        }
    }

    public String func_145825_b() {
        return "Security Manager Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return ((Object)((Object)SecuritySetup.securityCardItem)).equals(stack.func_77973_b());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i + 0, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETCHANNELNAME.equals(command)) {
            this.setChannelName(args.get("name").getString());
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setWhiteListMode(args.get("whitelist").getBoolean());
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer(args.get("player").getString());
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer(args.get("player").getString());
            return true;
        }
        return false;
    }
}

