/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.entity.GenericTileEntity;
import mcjty.rftools.blocks.security.PacketGetSecurityName;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.varia.Logging;
import mcjty.varia.SecurityTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class SecurityCardItem
extends Item {
    private IIcon activeIcon;
    public static String channelNameFromServer = "";
    private static long lastTime = 0L;

    public SecurityCardItem() {
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.activeIcon = iconRegister.func_94245_a("rftools:securityCardItem_linked");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        int channel = -1;
        if (tagCompound != null && tagCompound.func_74764_b("channel")) {
            channel = tagCompound.func_74762_e("channel");
        }
        if (channel != -1) {
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetSecurityName(channel));
            }
            list.add(EnumChatFormatting.YELLOW + "Channel: " + channel + " (" + channelNameFromServer + ")");
        } else {
            list.add(EnumChatFormatting.YELLOW + "Channel is not set!");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "Manage security channels in the Security Manager");
            list.add(EnumChatFormatting.WHITE + "and link this card to a channel. Sneak right-click");
            list.add(EnumChatFormatting.WHITE + "a block to link the channel to that block.");
            list.add(EnumChatFormatting.WHITE + "If you want to copy the channel from a block to");
            list.add(EnumChatFormatting.WHITE + "a card you can right click with an unlinked card");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof GenericTileEntity) {
                GenericTileEntity genericTileEntity = (GenericTileEntity)te;
                if (genericTileEntity.getOwnerUUID() == null) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "This block has no owner!"));
                } else if (SecurityTools.isAdmin((EntityPlayer)player) || this.isOwner(player, genericTileEntity)) {
                    NBTTagCompound tagCompound = stack.func_77978_p();
                    if (tagCompound == null || !tagCompound.func_74764_b("channel")) {
                        int blockSecurity = genericTileEntity.getSecurityChannel();
                        if (blockSecurity == -1) {
                            Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "This security card is not setup correctly!"));
                        } else {
                            if (tagCompound == null) {
                                tagCompound = new NBTTagCompound();
                                stack.func_77982_d(tagCompound);
                            }
                            tagCompound.func_74768_a("channel", blockSecurity);
                            Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Copied security channel from block to card!"));
                        }
                    } else {
                        int channel = tagCompound.func_74762_e("channel");
                        this.toggleSecuritySettings(player, genericTileEntity, channel);
                    }
                } else {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "You cannot change security settings of a block you don't own!"));
                }
            } else {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Security is not supported on this block!"));
            }
            return true;
        }
        return true;
    }

    private boolean isOwner(EntityPlayer player, GenericTileEntity genericTileEntity) {
        return genericTileEntity.getOwnerUUID().equals(player.getPersistentID());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("channel")) {
            return this.activeIcon;
        }
        return this.field_77791_bV;
    }

    private void toggleSecuritySettings(EntityPlayer player, GenericTileEntity genericTileEntity, int channel) {
        int sec = genericTileEntity.getSecurityChannel();
        if (sec == channel) {
            genericTileEntity.setSecurityChannel(-1);
            Logging.message((EntityPlayer)player, (String)"Security settings cleared from block!");
        } else {
            genericTileEntity.setSecurityChannel(channel);
            Logging.message((EntityPlayer)player, (String)"Security settings applied on block!");
        }
    }
}

