/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.rftools.blocks.logic.RedstoneChannels;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ScreenModule;
import mcjty.varia.Coordinate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RedstoneScreenModule
implements ScreenModule {
    private int channel = -1;
    private Coordinate coordinate = Coordinate.INVALID;
    private int dim = 0;
    private int side = 0;

    @Override
    public Object[] getData(World worldObj, long millis) {
        if (this.channel == -1) {
            WorldServer world;
            if (this.coordinate.isValid() && (world = DimensionManager.getWorld((int)this.dim)) != null) {
                int powerTo = world.func_72878_l(this.coordinate.getX(), this.coordinate.getY(), this.coordinate.getZ(), this.side);
                return new Object[]{powerTo > 0};
            }
            return null;
        }
        RedstoneChannels channels = RedstoneChannels.getChannels();
        if (channels == null) {
            return null;
        }
        RedstoneChannels.RedstoneChannel ch = channels.getChannel(this.channel);
        if (ch == null) {
            return null;
        }
        return new Object[]{ch.getValue() != 0};
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        if (tagCompound != null) {
            this.channel = -1;
            if (tagCompound.func_74764_b("channel")) {
                this.channel = tagCompound.func_74762_e("channel");
            }
            if (tagCompound.func_74764_b("monitorx")) {
                this.side = tagCompound.func_74762_e("monitorside");
                this.dim = tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    Coordinate c = new Coordinate(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.getX() - x);
                    int dy = Math.abs(c.getY() - y);
                    int dz = Math.abs(c.getZ() - z);
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.REDSTONE_RFPERTICK;
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }
}

