/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import cofh.api.energy.IEnergyConnection;
import java.util.Map;
import mcjty.entity.GenericEnergyHandlerTileEntity;
import mcjty.network.Argument;
import mcjty.rftools.varia.EnergyTools;
import mcjty.varia.BlockTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RelayTileEntity
extends GenericEnergyHandlerTileEntity {
    public static final int MAXENERGY = 50000;
    public static final int RECEIVEPERTICK = 50000;
    public static final String CMD_SETTINGS = "settings";
    private boolean[] inputModeOn = new boolean[]{false, false, false, false, false, false};
    private boolean[] inputModeOff = new boolean[]{false, false, false, false, false, false};
    private int[] rfOn = new int[]{1000, 1000, 1000, 1000, 1000, 1000};
    private int[] rfOff = new int[]{0, 0, 0, 0, 0, 0};
    public static final String DUNSWE = "DUNSWE";

    public RelayTileEntity() {
        super(50000, 50000);
    }

    protected void checkStateServer() {
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean redstoneSignal = BlockTools.getRedstoneSignal((int)meta);
        int[] rf = redstoneSignal ? this.rfOn : this.rfOff;
        boolean[] inputMode = redstoneSignal ? this.inputModeOn : this.inputModeOff;
        int energyStored = this.getEnergyStored(ForgeDirection.DOWN);
        if (energyStored <= 0) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int rfToGive;
            int received;
            ForgeDirection opposite;
            IEnergyConnection connection;
            int side = BlockTools.reorient((ForgeDirection)ForgeDirection.values()[i], (int)meta).ordinal();
            if (rf[side] <= 0 || inputMode[side]) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!EnergyTools.isEnergyTE(te) || !(connection = (IEnergyConnection)te).canConnectEnergy(opposite = dir.getOpposite()) || (energyStored -= this.extractEnergy(ForgeDirection.DOWN, received = EnergyTools.receiveEnergy(te, opposite, rfToGive = rf[side] <= energyStored ? rf[side] : energyStored), false)) > 0) continue;
            return;
        }
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int side;
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean redstoneSignal = BlockTools.getRedstoneSignal((int)meta);
        boolean[] inputMode = redstoneSignal ? this.inputModeOn : this.inputModeOff;
        if (inputMode[side = BlockTools.reorient((ForgeDirection)from, (int)meta).ordinal()]) {
            int[] rf = redstoneSignal ? this.rfOn : this.rfOff;
            return super.receiveEnergy(from, Math.min(maxReceive, rf[side]), simulate);
        }
        return 0;
    }

    public boolean isInputModeOn(int side) {
        return this.inputModeOn[side];
    }

    public boolean isInputModeOff(int side) {
        return this.inputModeOff[side];
    }

    public int getRfOn(int side) {
        return this.rfOn[side];
    }

    public int getRfOff(int side) {
        return this.rfOff[side];
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        if (tagCompound.func_74764_b("rfOn")) {
            int on = tagCompound.func_74762_e("rfOn");
            int off = tagCompound.func_74762_e("rfOff");
            for (int i = 0; i < 6; ++i) {
                this.rfOn[i] = on;
                this.rfOff[i] = off;
                this.inputModeOn[i] = false;
                this.inputModeOff[i] = false;
            }
        } else {
            int i;
            int[] on = tagCompound.func_74759_k("on");
            int[] off = tagCompound.func_74759_k("off");
            System.arraycopy(on, 0, this.rfOn, 0, Math.min(6, on.length));
            System.arraycopy(off, 0, this.rfOff, 0, Math.min(6, off.length));
            byte[] inOn = tagCompound.func_74770_j("inputOn");
            byte[] inOff = tagCompound.func_74770_j("inputOff");
            for (i = 0; i < Math.min(6, inOn.length); ++i) {
                this.inputModeOn[i] = inOn[i] > 0;
            }
            for (i = 0; i < Math.min(6, inOff.length); ++i) {
                this.inputModeOff[i] = inOff[i] > 0;
            }
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74783_a("on", this.rfOn);
        tagCompound.func_74783_a("off", this.rfOff);
        byte[] inOn = new byte[6];
        byte[] inOff = new byte[6];
        for (int i = 0; i < 6; ++i) {
            inOn[i] = (byte)(this.inputModeOn[i] ? 1 : 0);
            inOff[i] = (byte)(this.inputModeOff[i] ? 1 : 0);
        }
        tagCompound.func_74773_a("inputOn", inOn);
        tagCompound.func_74773_a("inputOff", inOff);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            for (int i = 0; i < 6; ++i) {
                char prefix = DUNSWE.charAt(i);
                this.inputModeOn[i] = args.get(prefix + "InOn").getBoolean();
                this.inputModeOff[i] = args.get(prefix + "InOff").getBoolean();
                this.rfOn[i] = args.get(prefix + "On").getInteger();
                this.rfOff[i] = args.get(prefix + "Off").getInteger();
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }
}

