/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.network.Argument;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.environmental.EnvModuleProvider;
import mcjty.rftools.blocks.environmental.EnvironmentalConfiguration;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerContainer;
import mcjty.rftools.blocks.environmental.GuiEnvironmentalController;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import mcjty.rftools.blocks.teleporter.PlayerName;
import mcjty.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnvironmentalControllerTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final String CMD_SETRADIUS = "setRadius";
    public static final String CMD_SETBOUNDS = "setBounds";
    public static final String CMD_RSMODE = "rsMode";
    public static final String CMD_SETBLACKLIST = "setBlacklist";
    public static final String CMD_ADDPLAYER = "addPlayer";
    public static final String CMD_DELPLAYER = "delPlayer";
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, EnvironmentalControllerContainer.factory, 7);
    private List<EnvironmentModule> environmentModules = null;
    private Set<String> players = new HashSet<String>();
    private boolean whitelistMode = false;
    private int totalRfPerTick = 0;
    private int radius = 50;
    private int miny = 30;
    private int maxy = 70;
    private int volume = -1;
    private boolean active = false;
    private RedstoneMode redstoneMode = RedstoneMode.REDSTONE_IGNORED;
    private int powered = 0;
    private int powerTimeout = 0;

    public EnvironmentalControllerTileEntity() {
        super(EnvironmentalConfiguration.ENVIRONMENTAL_MAXENERGY, EnvironmentalConfiguration.ENVIRONMENTAL_RECEIVEPERTICK);
    }

    public boolean isWhitelistMode() {
        return this.whitelistMode;
    }

    public boolean isPlayerAffected(EntityPlayer player) {
        if (this.whitelistMode) {
            return this.players.contains(player.getDisplayName());
        }
        return !this.players.contains(player.getDisplayName());
    }

    public List<PlayerName> getPlayersAsList() {
        ArrayList<PlayerName> p = new ArrayList<PlayerName>();
        for (String player : this.players) {
            p.add(new PlayerName(player));
        }
        return p;
    }

    public void addPlayer(String player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public void delPlayer(String player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTotalRfPerTick() {
        if (this.environmentModules == null) {
            this.getEnvironmentModules();
        }
        int rfNeeded = (int)((float)this.totalRfPerTick * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.environmentModules.isEmpty()) {
            return rfNeeded;
        }
        if (rfNeeded < EnvironmentalConfiguration.MIN_USAGE) {
            rfNeeded = EnvironmentalConfiguration.MIN_USAGE;
        }
        return rfNeeded;
    }

    public int getVolume() {
        if (this.volume == -1) {
            this.volume = (int)((double)(this.radius * this.radius) * Math.PI * (double)(this.maxy - this.miny + 1));
        }
        return this.volume;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.volume = -1;
        this.environmentModules = null;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getMiny() {
        return this.miny;
    }

    public void setMiny(int miny) {
        this.miny = miny;
        this.volume = -1;
        this.environmentModules = null;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getMaxy() {
        return this.maxy;
    }

    public void setMaxy(int maxy) {
        this.maxy = maxy;
        this.volume = -1;
        this.environmentModules = null;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void checkStateServer() {
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            return;
        }
        int rf = this.getEnergyStored(ForgeDirection.DOWN);
        if (this.redstoneMode != RedstoneMode.REDSTONE_IGNORED) {
            boolean rs;
            boolean bl = rs = this.powered > 0;
            if (this.redstoneMode == RedstoneMode.REDSTONE_OFFREQUIRED) {
                if (rs) {
                    rf = 0;
                }
            } else if (this.redstoneMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                rf = 0;
            }
        }
        this.getEnvironmentModules();
        int rfNeeded = this.getTotalRfPerTick();
        if (rfNeeded > rf || this.environmentModules.isEmpty()) {
            for (EnvironmentModule module : this.environmentModules) {
                module.activate(false);
            }
            this.powerTimeout = 20;
            if (this.active) {
                this.active = false;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            this.consumeEnergy(rfNeeded);
            for (EnvironmentModule module : this.environmentModules) {
                module.activate(true);
                module.tick(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.radius, this.miny, this.maxy, this);
            }
            if (!this.active) {
                this.active = true;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setPowered(int powered) {
        if (this.powered != powered) {
            this.powered = powered;
            this.powerTimeout = 0;
            this.func_70296_d();
        }
    }

    public List<EnvironmentModule> getEnvironmentModules() {
        if (this.environmentModules == null) {
            int volume = this.getVolume();
            this.totalRfPerTick = 0;
            this.environmentModules = new ArrayList<EnvironmentModule>();
            for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
                EnvironmentModule environmentModule;
                ItemStack itemStack = this.inventoryHelper.getStackInSlot(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof EnvModuleProvider)) continue;
                EnvModuleProvider moduleProvider = (EnvModuleProvider)itemStack.func_77973_b();
                Class<? extends EnvironmentModule> moduleClass = moduleProvider.getServerEnvironmentModule();
                try {
                    environmentModule = moduleClass.newInstance();
                }
                catch (InstantiationException e) {
                    Logging.log((String)"Failed to instantiate controller module!");
                    continue;
                }
                catch (IllegalAccessException e) {
                    Logging.log((String)"Failed to instantiate controller module!");
                    continue;
                }
                this.environmentModules.add(environmentModule);
                this.totalRfPerTick += (int)(environmentModule.getRfPerTick() * (float)volume);
            }
        }
        return this.environmentModules;
    }

    public int[] func_94128_d(int side) {
        return EnvironmentalControllerContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return EnvironmentalControllerContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return EnvironmentalControllerContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        this.environmentModules = null;
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        this.environmentModules = null;
    }

    public String func_145825_b() {
        return "Environmental Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.totalRfPerTick = tagCompound.func_74762_e("rfPerTick");
        this.active = tagCompound.func_74767_n("active");
        this.powered = tagCompound.func_74771_c("powered");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.radius = tagCompound.func_74762_e("radius");
        this.miny = tagCompound.func_74762_e("miny");
        this.maxy = tagCompound.func_74762_e("maxy");
        this.volume = -1;
        byte m = tagCompound.func_74771_c(CMD_RSMODE);
        this.redstoneMode = RedstoneMode.values()[m];
        this.whitelistMode = tagCompound.func_74767_n("whitelist");
        this.players.clear();
        NBTTagList playerList = tagCompound.func_150295_c("players", 8);
        if (playerList != null) {
            for (int i = 0; i < playerList.func_74745_c(); ++i) {
                String player = playerList.func_150307_f(i);
                this.players.add(player);
            }
        }
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i + 0, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
        this.environmentModules = null;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("rfPerTick", this.totalRfPerTick);
        tagCompound.func_74757_a("active", this.active);
        tagCompound.func_74774_a("powered", (byte)this.powered);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("radius", this.radius);
        tagCompound.func_74768_a("miny", this.miny);
        tagCompound.func_74768_a("maxy", this.maxy);
        tagCompound.func_74774_a(CMD_RSMODE, (byte)this.redstoneMode.ordinal());
        tagCompound.func_74757_a("whitelist", this.whitelistMode);
        NBTTagList playerTagList = new NBTTagList();
        for (String player : this.players) {
            playerTagList.func_74742_a((NBTBase)new NBTTagString(player));
        }
        tagCompound.func_74782_a("players", (NBTBase)playerTagList);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETRADIUS.equals(command)) {
            this.setRadius(args.get("radius").getInteger());
            return true;
        }
        if (CMD_SETBOUNDS.equals(command)) {
            int miny = args.get("miny").getInteger();
            int maxy = args.get("maxy").getInteger();
            this.setMiny(miny);
            this.setMaxy(maxy);
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRedstoneMode(RedstoneMode.getMode(m));
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer(args.get("player").getString());
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer(args.get("player").getString());
            return true;
        }
        return false;
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return this.getPlayersAsList();
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            GuiEnvironmentalController.storePlayersForClient(list);
            return true;
        }
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

