/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import java.util.Map;
import mcjty.entity.GenericTileEntity;
import mcjty.entity.SyncedObject;
import mcjty.entity.SyncedValue;
import mcjty.network.Argument;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.varia.BlockTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class DimensionMonitorTileEntity
extends GenericTileEntity {
    public static final String CMD_SETALARM = "setAlarm";
    private int alarmLevel = 0;
    private int ticker = 10;
    private SyncedValue<Boolean> redstoneOut = new SyncedValue((Object)false);

    public DimensionMonitorTileEntity() {
        this.registerSyncedObject((SyncedObject)this.redstoneOut);
    }

    public int getAlarmLevel() {
        return this.alarmLevel;
    }

    public void setAlarmLevel(int level) {
        this.alarmLevel = level;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void checkStateServer() {
        boolean newout;
        super.checkStateServer();
        --this.ticker;
        if (this.ticker > 0) {
            return;
        }
        this.ticker = 10;
        DimensionStorage storage = DimensionStorage.getDimensionStorage(this.field_145850_b);
        int energy = storage.getEnergyLevel(this.field_145850_b.field_73011_w.field_76574_g);
        int pct = energy / (DimletConfiguration.MAX_DIMENSION_POWER / 100);
        boolean bl = newout = pct < this.alarmLevel;
        if (newout != (Boolean)this.redstoneOut.getValue()) {
            this.redstoneOut.setValue((Object)newout);
            this.notifyBlockUpdate();
        }
    }

    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        Boolean value = (Boolean)this.redstoneOut.getValue();
        return BlockTools.setRedstoneSignalOut((int)meta, (boolean)(value == null ? false : value));
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.redstoneOut.setValue((Object)tagCompound.func_74767_n("rs"));
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.alarmLevel = tagCompound.func_74762_e("level");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        Boolean value = (Boolean)this.redstoneOut.getValue();
        tagCompound.func_74757_a("rs", value == null ? false : value);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("level", this.alarmLevel);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETALARM.equals(command)) {
            this.setAlarmLevel(args.get("level").getInteger());
            return true;
        }
        return false;
    }
}

