/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Map;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.network.Argument;
import mcjty.network.PacketRequestIntegerFromServer;
import mcjty.rftools.blocks.dimlets.DimensionEditorContainer;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletResearcherContainer;
import mcjty.rftools.blocks.teleporter.TeleporterSetup;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.world.WorldGenerationTools;
import mcjty.rftools.items.dimlets.DimletCosts;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.items.dimlets.types.IDimletType;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.varia.BlockTools;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DimensionEditorTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final String CMD_GETEDITING = "getEditing";
    public static final String CLIENTCMD_GETEDITING = "getEditing";
    private static int editPercentage = 0;
    private int ticksLeft = -1;
    private int ticksCost = -1;
    private int rfPerTick = -1;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimensionEditorContainer.factory, 2);

    public DimensionEditorTileEntity() {
        super(DimletConfiguration.EDITOR_MAXENERGY, DimletConfiguration.EDITOR_RECEIVEPERTICK);
    }

    protected void checkStateServer() {
        ItemStack injectableItemStack = this.validateInjectableItemStack();
        if (injectableItemStack == null) {
            return;
        }
        ItemStack dimensionItemStack = this.validateDimensionItemStack();
        if (dimensionItemStack == null) {
            return;
        }
        if (this.ticksLeft == -1) {
            if (this.isMatterReceiver(injectableItemStack)) {
                this.ticksLeft = this.ticksCost = DimletCosts.baseDimensionTickCost + 1000;
                this.rfPerTick = DimletCosts.baseDimensionCreationCost + 200;
            } else {
                DimletKey key = KnownDimletConfiguration.getDimletKey(injectableItemStack, this.field_145850_b);
                DimletEntry dimletEntry = KnownDimletConfiguration.getEntry(key);
                this.ticksLeft = this.ticksCost = DimletCosts.baseDimensionTickCost + dimletEntry.getTickCost();
                this.rfPerTick = DimletCosts.baseDimensionCreationCost + dimletEntry.getRfCreateCost();
            }
        } else {
            int rf = this.getEnergyStored(ForgeDirection.DOWN);
            int rfpt = this.rfPerTick;
            if (rf >= (rfpt = (int)((float)rfpt * (2.0f - this.getInfusedFactor()) / 2.0f))) {
                this.consumeEnergy(rfpt);
                --this.ticksLeft;
                if (this.ticksLeft <= 0) {
                    RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(this.field_145850_b);
                    ItemStack dimensionTab = this.validateDimensionItemStack();
                    NBTTagCompound tagCompound = dimensionTab.func_77978_p();
                    int id = tagCompound.func_74762_e("id");
                    injectableItemStack = this.validateInjectableItemStack();
                    if (this.isMatterReceiver(injectableItemStack)) {
                        World dimWorld = RfToolsDimensionManager.getWorldForDimension(id);
                        int y = this.findGoodReceiverLocation(dimWorld);
                        if (y == -1) {
                            y = dimWorld.func_72800_K() / 2;
                        }
                        dimWorld.func_147465_d(8, y, 8, (Block)TeleporterSetup.matterReceiverBlock, 0, 2);
                        TeleporterSetup.matterReceiverBlock.func_149660_a(dimWorld, 8, y, 8, 0, 0.0f, 0.0f, 0.0f, 0);
                        TeleporterSetup.matterReceiverBlock.func_149689_a(dimWorld, 8, y, 8, null, injectableItemStack);
                        dimWorld.func_147468_f(8, y + 1, 8);
                        dimWorld.func_147468_f(8, y + 2, 8);
                    } else {
                        DimletKey key = KnownDimletConfiguration.getDimletKey(injectableItemStack, this.field_145850_b);
                        DimensionInformation information = dimensionManager.getDimensionInformation(id);
                        information.injectDimlet(key);
                        dimensionManager.save(this.field_145850_b);
                    }
                    this.inventoryHelper.decrStackSize(0, 1);
                    this.stopInjecting();
                }
            }
        }
        this.func_70296_d();
        this.setState();
    }

    private int findGoodReceiverLocation(World dimWorld) {
        int y = WorldGenerationTools.findSuitableEmptySpot(dimWorld, 8, 8);
        return ++y;
    }

    private ItemStack validateInjectableItemStack() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack == null || itemStack.field_77994_a == 0) {
            this.stopInjecting();
            return null;
        }
        if (this.isMatterReceiver(itemStack)) {
            return itemStack;
        }
        DimletKey key = KnownDimletConfiguration.getDimletKey(itemStack, this.field_145850_b);
        DimletType type = key.getType();
        IDimletType itype = type.dimletType;
        if (itype.isInjectable()) {
            return itemStack;
        }
        return null;
    }

    private boolean isMatterReceiver(ItemStack itemStack) {
        Block block = BlockTools.getBlock((ItemStack)itemStack);
        return block == TeleporterSetup.matterReceiverBlock;
    }

    private ItemStack validateDimensionItemStack() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(1);
        if (itemStack == null || itemStack.field_77994_a == 0) {
            this.stopInjecting();
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        int id = tagCompound.func_74762_e("id");
        if (id == 0) {
            this.stopInjecting();
            return null;
        }
        return itemStack;
    }

    private void stopInjecting() {
        this.setState();
        this.ticksLeft = -1;
        this.ticksCost = -1;
        this.rfPerTick = -1;
        this.func_70296_d();
    }

    private void setState() {
        int state = 0;
        state = this.ticksLeft == 0 ? 0 : (this.ticksLeft == -1 ? 1 : ((this.ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int newmeta = BlockTools.setState((int)metadata, (int)state);
        if (newmeta != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newmeta, 2);
        }
    }

    public int[] func_94128_d(int side) {
        return DimletResearcherContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return DimletResearcherContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return DimletResearcherContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Editor Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return DimletConfiguration.dimletStackSize;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void requestBuildingPercentage() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getEditing", "getEditing", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getEditing".equals(command)) {
            if (this.ticksLeft == -1) {
                return 0;
            }
            return (this.ticksCost - this.ticksLeft) * 100 / this.ticksCost;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getEditing".equals(command)) {
            editPercentage = result;
            return true;
        }
        return false;
    }

    public static int getEditPercentage() {
        return editPercentage;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.ticksLeft = tagCompound.func_74762_e("ticksLeft");
        this.ticksCost = tagCompound.func_74762_e("ticksCost");
        this.rfPerTick = tagCompound.func_74762_e("rfPerTick");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("ticksLeft", this.ticksLeft);
        tagCompound.func_74768_a("ticksCost", this.ticksCost);
        tagCompound.func_74768_a("rfPerTick", this.rfPerTick);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }
}

