/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimletconstruction;

import java.util.Map;
import java.util.Random;
import mcjty.entity.GenericTileEntity;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.varia.BlockTools;
import net.minecraft.nbt.NBTTagCompound;

public class TimeAbsorberTileEntity
extends GenericTileEntity {
    private int absorbing = 0;
    private float angle = -1.0f;
    private boolean prevIn = false;
    private int registerTimeout = 0;

    protected void checkStateClient() {
        if (this.absorbing > 0) {
            Random rand = this.field_145850_b.field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.field_145850_b.func_72869_a("portal", (double)((float)this.field_145851_c + 0.5f) + x * r, (double)((float)this.field_145848_d + 0.5f) + y * r, (double)((float)this.field_145849_e + 0.5f) + z * r, -x, -y, -z);
        }
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public float getAngle() {
        return this.angle;
    }

    public int getRegisterTimeout() {
        return this.registerTimeout;
    }

    protected void checkStateServer() {
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean newvalue = BlockTools.getRedstoneSignalIn((int)meta);
        boolean pulse = newvalue && !this.prevIn;
        this.prevIn = newvalue;
        this.func_70296_d();
        if (this.registerTimeout > 0) {
            --this.registerTimeout;
            return;
        }
        if (pulse) {
            this.registerTime();
        }
    }

    private void registerTime() {
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            float a = this.field_145850_b.func_72826_c(1.0f);
            DimletKey bestDimlet = TimeAbsorberTileEntity.findBestTimeDimlet(a);
            float besta = DimletObjectMapping.idToCelestialAngle.get(bestDimlet).floatValue();
            if (this.angle < -0.001f) {
                this.angle = besta;
                this.absorbing = DimletConstructionConfiguration.maxTimeAbsorbtion - 1;
            } else if (Math.abs(besta - this.angle) < 0.1f) {
                --this.absorbing;
                if (this.absorbing < 0) {
                    this.absorbing = 0;
                }
                this.registerTimeout = 3000;
            } else {
                ++this.absorbing;
                if (this.absorbing >= DimletConstructionConfiguration.maxTimeAbsorbtion) {
                    this.absorbing = DimletConstructionConfiguration.maxTimeAbsorbtion - 1;
                }
            }
        }
    }

    public static DimletKey findBestTimeDimlet(float a) {
        float bestDiff = 10000.0f;
        DimletKey bestDimlet = null;
        for (Map.Entry<DimletKey, Float> entry : DimletObjectMapping.idToCelestialAngle.entrySet()) {
            Float celangle = entry.getValue();
            if (celangle == null) continue;
            float diff = Math.abs(a - celangle.floatValue());
            if (diff < bestDiff) {
                bestDiff = diff;
                bestDimlet = entry.getKey();
            }
            if ((diff = Math.abs(a - 1.0f - celangle.floatValue())) < bestDiff) {
                bestDiff = diff;
                bestDimlet = entry.getKey();
            }
            if (!((diff = Math.abs(a + 1.0f - celangle.floatValue())) < bestDiff)) continue;
            bestDiff = diff;
            bestDimlet = entry.getKey();
        }
        return bestDimlet;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("prevIn", this.prevIn);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("absorbing", this.absorbing);
        tagCompound.func_74776_a("angle", this.angle);
        tagCompound.func_74768_a("registerTimeout", this.registerTimeout);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.absorbing = tagCompound.func_74762_e("absorbing");
        this.angle = tagCompound.func_74764_b("angle") ? tagCompound.func_74760_g("angle") : -1.0f;
        this.registerTimeout = tagCompound.func_74762_e("registerTimeout");
    }
}

