/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.blockprotector;

import java.util.Map;
import java.util.Set;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.entity.SyncedObject;
import mcjty.entity.SyncedValueSet;
import mcjty.network.Argument;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.items.smartwrench.SmartWrenchSelector;
import mcjty.varia.BlockTools;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import mcjty.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockProtectorTileEntity
extends GenericEnergyReceiverTileEntity
implements SmartWrenchSelector {
    public static final String CMD_RSMODE = "rsMode";
    private RedstoneMode redstoneMode = RedstoneMode.REDSTONE_IGNORED;
    private int powered = 0;
    private int id = -1;
    private SyncedValueSet<Coordinate> protectedBlocks = new SyncedValueSet<Coordinate>(){

        public Coordinate readElementFromNBT(NBTTagCompound tagCompound) {
            return Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"c");
        }

        public NBTTagCompound writeElementToNBT(Coordinate element) {
            return Coordinate.writeToNBT((Coordinate)element);
        }
    };

    public BlockProtectorTileEntity() {
        super(BlockProtectorConfiguration.MAXENERGY, BlockProtectorConfiguration.RECEIVEPERTICK);
        this.registerSyncedObject((SyncedObject)this.protectedBlocks);
    }

    protected void checkStateServer() {
        if (this.protectedBlocks.isEmpty()) {
            this.setState(0);
            return;
        }
        if (this.isDisabled()) {
            this.setState(0);
            return;
        }
        this.setState(1);
        this.consumeEnergy(this.protectedBlocks.size() * BlockProtectorConfiguration.rfPerProtectedBlock);
    }

    private void setState(int state) {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int newmeta = BlockTools.setState((int)metadata, (int)state);
        if (newmeta != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newmeta, 2);
        }
    }

    private boolean isDisabled() {
        if (this.redstoneMode != RedstoneMode.REDSTONE_IGNORED) {
            boolean rs;
            boolean bl = rs = this.powered > 0;
            if (this.redstoneMode == RedstoneMode.REDSTONE_OFFREQUIRED ? rs : this.redstoneMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                return true;
            }
        }
        return false;
    }

    public void setPowered(int powered) {
        if (this.powered != powered) {
            this.powered = powered;
            this.func_70296_d();
        }
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode(mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRedstoneMode(redstoneMode);
        return null;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public boolean attemptHarvestProtection() {
        if (this.isDisabled()) {
            return false;
        }
        int rf = this.getEnergyStored(ForgeDirection.DOWN);
        if (BlockProtectorConfiguration.rfForHarvestAttempt > rf) {
            return false;
        }
        this.consumeEnergy(BlockProtectorConfiguration.rfForHarvestAttempt);
        return true;
    }

    public int attemptExplosionProtection(float distance, float radius) {
        if (this.isDisabled()) {
            return -1;
        }
        int rf = this.getEnergyStored(ForgeDirection.DOWN);
        int rfneeded = (int)((double)BlockProtectorConfiguration.rfForExplosionProtection * (1.0 - (double)distance) * (double)radius / 8.0) + 1;
        if ((rfneeded = (int)((float)rfneeded * (2.0f - this.getInfusedFactor()) / 2.0f)) > rf) {
            return -1;
        }
        if (rfneeded <= 0) {
            rfneeded = 1;
        }
        this.consumeEnergy(rfneeded);
        return rfneeded;
    }

    public Set<Coordinate> getProtectedBlocks() {
        return this.protectedBlocks;
    }

    public Coordinate absoluteToRelative(Coordinate c) {
        return this.absoluteToRelative(c.getX(), c.getY(), c.getZ());
    }

    public Coordinate absoluteToRelative(int x, int y, int z) {
        return new Coordinate(x - this.field_145851_c, y - this.field_145848_d, z - this.field_145849_e);
    }

    public boolean isProtected(Coordinate c) {
        return this.protectedBlocks.contains((Object)c);
    }

    public void removeProtection(Coordinate relative) {
        this.protectedBlocks.remove((Object)relative);
        this.func_70296_d();
        this.notifyBlockUpdate();
    }

    public void toggleCoordinate(GlobalCoordinate c) {
        if (c.getDimension() != this.field_145850_b.field_73011_w.field_76574_g) {
            return;
        }
        Coordinate relative = this.absoluteToRelative(c.getCoordinate());
        if (this.protectedBlocks.contains((Object)relative)) {
            this.protectedBlocks.remove((Object)relative);
        } else {
            this.protectedBlocks.add((Object)relative);
        }
        this.func_70296_d();
        this.notifyBlockUpdate();
    }

    @Override
    public void selectBlock(EntityPlayer player, int x, int y, int z) {
        if (Math.abs(x - this.field_145851_c) > BlockProtectorConfiguration.maxProtectDistance || Math.abs(y - this.field_145848_d) > BlockProtectorConfiguration.maxProtectDistance || Math.abs(z - this.field_145849_e) > BlockProtectorConfiguration.maxProtectDistance) {
            Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Block out of range of the block protector!"));
            return;
        }
        GlobalCoordinate gc = new GlobalCoordinate(new Coordinate(x, y, z), this.field_145850_b.field_73011_w.field_76574_g);
        this.toggleCoordinate(gc);
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            BlockProtectors protectors = BlockProtectors.getProtectors(this.field_145850_b);
            GlobalCoordinate gc = new GlobalCoordinate(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g);
            this.id = protectors.getNewId(gc);
            protectors.save(this.field_145850_b);
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void updateDestination() {
        BlockProtectors protectors = BlockProtectors.getProtectors(this.field_145850_b);
        GlobalCoordinate gc = new GlobalCoordinate(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g);
        if (this.id == -1) {
            this.id = protectors.getNewId(gc);
            this.func_70296_d();
        } else {
            protectors.assignId(gc, this.id);
        }
        protectors.save(this.field_145850_b);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.protectedBlocks.readFromNBT(tagCompound, "coordinates");
        this.powered = tagCompound.func_74771_c("powered");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.id = tagCompound.func_74764_b("protectorId") ? tagCompound.func_74762_e("protectorId") : -1;
        byte m = tagCompound.func_74771_c(CMD_RSMODE);
        this.redstoneMode = RedstoneMode.values()[m];
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.protectedBlocks.writeToNBT(tagCompound, "coordinates");
        tagCompound.func_74774_a("powered", (byte)this.powered);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("protectorId", this.id);
        tagCompound.func_74774_a(CMD_RSMODE, (byte)this.redstoneMode.ordinal());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRedstoneMode(RedstoneMode.getMode(m));
            return true;
        }
        return false;
    }
}

