/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks;

import cofh.api.item.IToolHammer;
import mcjty.base.ModBase;
import mcjty.container.GenericBlock;
import mcjty.container.WrenchUsage;
import mcjty.entity.GenericTileEntity;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.security.SecurityChannels;
import mcjty.rftools.items.smartwrench.SmartWrench;
import mcjty.rftools.items.smartwrench.SmartWrenchMode;
import mcjty.varia.Logging;
import mcjty.varia.SecurityTools;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public abstract class GenericRFToolsBlock
extends GenericBlock {
    public GenericRFToolsBlock(Material material, Class<? extends TileEntity> tileEntityClass, boolean isContainer) {
        super((ModBase)RFTools.instance, material, tileEntityClass, isContainer);
    }

    protected WrenchUsage getWrenchUsage(int x, int y, int z, EntityPlayer player, ItemStack itemStack, WrenchUsage wrenchUsed, Item item) {
        SmartWrench smartWrench;
        SmartWrenchMode mode;
        WrenchUsage usage = super.getWrenchUsage(x, y, z, player, itemStack, wrenchUsed, item);
        if (item instanceof IToolHammer && usage == WrenchUsage.DISABLED && item instanceof SmartWrench && (mode = (smartWrench = (SmartWrench)item).getMode(itemStack)).equals((Object)SmartWrenchMode.MODE_SELECT)) {
            usage = player.func_70093_af() ? WrenchUsage.SNEAK_SELECT : WrenchUsage.SELECT;
        }
        return usage;
    }

    protected boolean checkAccess(World world, EntityPlayer player, TileEntity te) {
        if (te instanceof GenericTileEntity) {
            int securityChannel;
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            if (!SecurityTools.isAdmin((EntityPlayer)player) && !player.getPersistentID().equals(genericTileEntity.getOwnerUUID()) && (securityChannel = genericTileEntity.getSecurityChannel()) != -1) {
                SecurityChannels securityChannels = SecurityChannels.getChannels(world);
                SecurityChannels.SecurityChannel channel = securityChannels.getChannel(securityChannel);
                boolean playerListed = channel.getPlayers().contains(player.getDisplayName());
                if (channel.isWhitelist() != playerListed) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "You have no permission to use this block!"));
                    return true;
                }
            }
        }
        return false;
    }
}

