/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mcjty.rftools.BedControl;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.environmental.PeacefulAreaManager;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.world.types.EffectType;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import mcjty.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        BlockProtectors blockProtectors = BlockProtectors.getProtectors(event.world);
        if (blockProtectors == null) {
            return;
        }
        int id = event.world.field_73011_w.field_76574_g;
        Collection<GlobalCoordinate> protectors = blockProtectors.findProtectors(event.x, event.y, event.z, id, 2);
        for (GlobalCoordinate protector : protectors) {
            Coordinate relative;
            BlockProtectorTileEntity blockProtectorTileEntity;
            boolean b;
            int cz;
            int cy;
            int cx = protector.getCoordinate().getX();
            TileEntity te = event.world.func_147438_o(cx, cy = protector.getCoordinate().getY(), cz = protector.getCoordinate().getZ());
            if (!(te instanceof BlockProtectorTileEntity) || !(b = (blockProtectorTileEntity = (BlockProtectorTileEntity)te).isProtected(relative = blockProtectorTileEntity.absoluteToRelative(event.x, event.y, event.z)))) continue;
            if (blockProtectorTileEntity.attemptHarvestProtection()) {
                event.setCanceled(true);
            } else {
                blockProtectorTileEntity.removeProtection(relative);
            }
            return;
        }
    }

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        BlockProtectors blockProtectors = BlockProtectors.getProtectors(event.world);
        if (blockProtectors == null) {
            return;
        }
        int id = event.world.field_73011_w.field_76574_g;
        Explosion explosion = event.explosion;
        Collection<GlobalCoordinate> protectors = blockProtectors.findProtectors((int)explosion.field_77284_b, (int)explosion.field_77285_c, (int)explosion.field_77282_d, id, (int)explosion.field_77280_f);
        if (protectors.isEmpty()) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        ArrayList<ChunkPosition> toremove = new ArrayList<ChunkPosition>();
        Vec3 explosionVector = Vec3.func_72443_a((double)explosion.field_77284_b, (double)explosion.field_77285_c, (double)explosion.field_77282_d);
        int rf = 0;
        for (GlobalCoordinate protector : protectors) {
            int cz;
            int cy;
            int cx = protector.getCoordinate().getX();
            TileEntity te = event.world.func_147438_o(cx, cy = protector.getCoordinate().getY(), cz = protector.getCoordinate().getZ());
            if (!(te instanceof BlockProtectorTileEntity)) continue;
            BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)te;
            for (ChunkPosition block : affectedBlocks) {
                Coordinate relative = blockProtectorTileEntity.absoluteToRelative(block.field_151329_a, block.field_151327_b, block.field_151328_c);
                boolean b = blockProtectorTileEntity.isProtected(relative);
                if (!b) continue;
                Vec3 blockVector = Vec3.func_72443_a((double)block.field_151329_a, (double)block.field_151327_b, (double)block.field_151328_c);
                double distanceTo = explosionVector.func_72438_d(blockVector);
                int rfneeded = blockProtectorTileEntity.attemptExplosionProtection((float)(distanceTo / (double)explosion.field_77280_f), explosion.field_77280_f);
                if (rfneeded > 0) {
                    toremove.add(block);
                    rf += rfneeded;
                    continue;
                }
                blockProtectorTileEntity.removeProtection(relative);
            }
        }
        for (ChunkPosition block : toremove) {
            affectedBlocks.remove(block);
        }
        Logging.logDebug((String)("RF Needed for one explosion:" + rf));
    }

    @SubscribeEvent
    public void onAttackEntityEvent(AttackEntityEvent event) {
        DimensionStorage storage;
        int energy;
        World world = event.entityPlayer.func_130014_f_();
        int id = world.field_73011_w.field_76574_g;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        if (dimensionManager.getDimensionInformation(id) != null && (energy = (storage = DimensionStorage.getDimensionStorage(world)).getEnergyLevel(id)) <= 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityConstructingEvent(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            PlayerExtendedProperties properties = new PlayerExtendedProperties();
            event.entity.registerExtendedProperties("RFToolsPlayerProperties", (IExtendedEntityProperties)properties);
        }
    }

    @SubscribeEvent
    public void onPlayerInterractEvent(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            RfToolsDimensionManager dimensionManager;
            Block block;
            World world = event.world;
            if (!world.field_72995_K && (block = world.func_147439_a(event.x, event.y, event.z)) instanceof BlockBed && (dimensionManager = RfToolsDimensionManager.getDimensionManager(world)).getDimensionInformation(world.field_73011_w.field_76574_g) != null) {
                switch (DimletConfiguration.bedBehaviour) {
                    case 0: {
                        event.setCanceled(true);
                        Logging.message((EntityPlayer)event.entityPlayer, (String)"You cannot sleep in this dimension!");
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        event.setCanceled(true);
                        int meta = BedControl.getBedMeta(world, event.x, event.y, event.z);
                        if (meta == -1) break;
                        BedControl.trySleep(world, event.entityPlayer, event.x, event.y, event.z, meta);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        int id = world.field_73011_w.field_76574_g;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
        if (dimensionInformation != null && dimensionInformation.isNoanimals() && event.entity instanceof IAnimals && !(event.entity instanceof IMob)) {
            event.setCanceled(true);
            Logging.logDebug((String)("Noanimals dimension: Prevented a spawn of " + event.entity.getClass().getName()));
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        DimensionStorage storage;
        int energy;
        World world = event.world;
        int id = world.field_73011_w.field_76574_g;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
        if (DimletConfiguration.preventSpawnUnpowered && dimensionInformation != null && (energy = (storage = DimensionStorage.getDimensionStorage(world)).getEnergyLevel(id)) <= 0) {
            event.setResult(Event.Result.DENY);
            Logging.logDebug((String)("Dimension power low: Prevented a spawn of " + event.entity.getClass().getName()));
        }
        if (dimensionInformation != null && (dimensionInformation.hasEffectType(EffectType.EFFECT_STRONGMOBS) || dimensionInformation.hasEffectType(EffectType.EFFECT_BRUTALMOBS)) && event.entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)event.entity;
            IAttributeInstance entityAttribute = entityLivingBase.func_110148_a(SharedMonsterAttributes.field_111267_a);
            double newMax = dimensionInformation.hasEffectType(EffectType.EFFECT_BRUTALMOBS) ? entityAttribute.func_111125_b() * DimletConfiguration.brutalMobsFactor : entityAttribute.func_111125_b() * DimletConfiguration.strongMobsFactor;
            entityAttribute.func_111128_a(newMax);
            entityLivingBase.func_70606_j((float)newMax);
        }
        if (event.entity instanceof IMob) {
            Coordinate coordinate = new Coordinate((int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v);
            if (PeacefulAreaManager.isPeaceful(new GlobalCoordinate(coordinate, id))) {
                event.setResult(Event.Result.DENY);
                Logging.logDebug((String)("Peaceful manager: Prevented a spawn of " + event.entity.getClass().getName()));
            } else if (dimensionInformation != null && dimensionInformation.isPeaceful()) {
                event.setResult(Event.Result.DENY);
                Logging.logDebug((String)("Peaceful dimension: Prevented a spawn of " + event.entity.getClass().getName()));
            }
        } else if (event.entity instanceof IAnimals && dimensionInformation != null && dimensionInformation.isNoanimals()) {
            event.setResult(Event.Result.DENY);
            Logging.logDebug((String)("Noanimals dimension: Prevented a spawn of " + event.entity.getClass().getName()));
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            PlayerExtendedProperties playerExtendedProperties = PlayerExtendedProperties.getProperties(player);
            if (!player.field_70170_p.field_72995_K) {
                if (playerExtendedProperties.getBuffProperties().hasBuff(PlayerBuff.BUFF_FEATHERFALLING)) {
                    event.distance /= 2.0f;
                } else if (playerExtendedProperties.getBuffProperties().hasBuff(PlayerBuff.BUFF_FEATHERFALLINGPLUS)) {
                    event.distance /= 8.0f;
                }
            }
        }
    }

    @SubscribeEvent
    public void onReplaceBiomeBlocks(ChunkProviderEvent.ReplaceBiomeBlocks event) {
        World world = event.world;
        if (world == null) {
            return;
        }
        int id = world.field_73011_w.field_76574_g;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(id);
        if (information != null && information.hasFeatureType(FeatureType.FEATURE_CLEAN)) {
            event.setResult(Event.Result.DENY);
        }
    }
}

