/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.relauncher.Side;
import mcjty.rftools.Achievements;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.blocks.endergen.EndergenicSetup;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.network.DimensionSyncPacket;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import mcjty.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.IExtendedEntityProperties;

public class FMLEventHandlers {
    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        IExtendedEntityProperties properties;
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.field_72995_K && (properties = event.player.getExtendedProperties("RFToolsPlayerProperties")) instanceof PlayerExtendedProperties) {
            PlayerExtendedProperties playerExtendedProperties = (PlayerExtendedProperties)properties;
            playerExtendedProperties.tick();
        }
    }

    @SubscribeEvent
    public void onItemPickupEvent(PlayerEvent.ItemPickupEvent event) {
        ItemStack stack;
        if (event.pickedUp != null && (stack = event.pickedUp.func_92059_d()) != null) {
            Item item = stack.func_77973_b();
            if (item == DimletSetup.unknownDimlet) {
                Achievements.trigger(event.player, Achievements.theFirstStep);
            } else if (item == DimletSetup.dimensionalShard) {
                Achievements.trigger(event.player, Achievements.specialOres);
            }
        }
    }

    @SubscribeEvent
    public void onItemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        Item item;
        if (event.crafting != null && (item = event.crafting.func_77973_b()) instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            if (itemBlock.field_150939_a == EndergenicSetup.endergenicBlock) {
                Achievements.trigger(event.player, Achievements.hardPower);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Logging.log((String)"SMP: Player logged in: Sync diminfo to clients");
        EntityPlayer player = event.player;
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(player.func_130014_f_());
        manager.syncDimInfoToClients(player.func_130014_f_());
        manager.checkDimletConfig(player);
    }

    @SubscribeEvent
    public void onConnectionCreated(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        Logging.log((String)"SMP: Sync dimensions to client");
        DimensionSyncPacket packet = new DimensionSyncPacket();
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(player.func_130014_f_());
        for (Integer id : manager.getDimensions().keySet()) {
            Logging.log((String)("Sending over dimension " + id + " to the client"));
            packet.addDimension(id);
        }
        RFTools.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        RFTools.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(event.manager.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        RFTools.channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }
}

