/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mods.defeatedcrow.api.recipe.IProcessorRecipe;
import mods.defeatedcrow.api.recipe.IProcessorRecipeRegister;
import mods.defeatedcrow.api.recipe.IProsessorRecipeRegister;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.AMTLogger;
import mods.defeatedcrow.common.DCsAppleMilk;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ProcessorRecipeRegister
implements IProcessorRecipeRegister,
IProsessorRecipeRegister {
    private static List<ProcessorRecipe> recipes;

    public ProcessorRecipeRegister() {
        recipes = new ArrayList<ProcessorRecipe>();
    }

    public IProcessorRecipeRegister instance() {
        return RecipeRegisterManager.processorRecipe;
    }

    @Override
    public void addRecipe(ItemStack output, boolean isFood, boolean forceReturn, ItemStack secondary, float secondaryChance, Object ... input) {
        float c = MathHelper.func_76131_a((float)0.0f, (float)secondaryChance, (float)1.0f);
        if (output == null || output.field_77994_a == 0) {
            output = null;
        }
        if (secondary == null || secondary.field_77994_a == 0) {
            secondary = null;
        }
        recipes.add(new ProcessorRecipe(output, secondary, isFood, forceReturn, c, input));
        AMTLogger.debugInfo("Add Prosessor recipe: output " + (output == null ? "null" : output.func_82833_r()));
    }

    @Override
    public void addRecipe(ItemStack output, boolean flag, ItemStack secondary, float secondaryChance, Object ... input) {
        float c = MathHelper.func_76131_a((float)0.0f, (float)secondaryChance, (float)1.0f);
        if (output == null || output.field_77994_a == 0) {
            output = null;
        }
        if (secondary == null || secondary.field_77994_a == 0) {
            secondary = null;
        }
        recipes.add(new ProcessorRecipe(output, secondary, flag, false, c, input));
        AMTLogger.debugInfo("Add Prosessor recipe: output " + (output == null ? "null" : output.func_82833_r()));
    }

    @Override
    public void addRecipe(ItemStack output, boolean flag, ItemStack secondary, Object ... input) {
        this.addRecipe(output, flag, secondary, 1.0f, input);
    }

    public List<ProcessorRecipe> getRecipes() {
        return recipes;
    }

    public class ProcessorRecipe
    implements IProcessorRecipe {
        public final ItemStack output;
        public final ItemStack secondary;
        private final Object[] input;
        private final ArrayList<Object> processedInput;
        private final float chance;
        private final boolean forceContainer;
        public final boolean foodRecipe;

        public ProcessorRecipe(ItemStack output, ItemStack sec, boolean flag, boolean flag2, float secondaryChance, Object ... inputs) {
            this.output = output;
            this.input = inputs;
            this.secondary = sec;
            this.foodRecipe = flag;
            this.forceContainer = flag2;
            this.chance = secondaryChance;
            this.processedInput = new ArrayList();
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] instanceof String) {
                    this.processedInput.add(OreDictionary.getOres((String)((String)inputs[i])));
                    continue;
                }
                if (inputs[i] instanceof ItemStack) {
                    this.processedInput.add(((ItemStack)inputs[i]).func_77946_l());
                    continue;
                }
                if (inputs[i] instanceof Item) {
                    this.processedInput.add(new ItemStack((Item)inputs[i], 1, 0));
                    continue;
                }
                if (inputs[i] instanceof Block) {
                    this.processedInput.add(new ItemStack((Block)inputs[i], 1, 0));
                    continue;
                }
                throw new IllegalArgumentException("Unknown Object passed to recipe!");
            }
        }

        @Override
        public Object[] getInput() {
            return this.input;
        }

        @Override
        public ItemStack getOutput() {
            return this.output == null ? null : this.output.func_77946_l();
        }

        @Override
        public float getChance() {
            return this.chance;
        }

        @Override
        public ItemStack getSecondary() {
            if (this.secondary != null) {
                return this.secondary.func_77946_l();
            }
            return null;
        }

        @Override
        public ItemStack getContainerItem(List<ItemStack> items) {
            ItemStack next;
            ItemStack cont = null;
            for (int i = 0; i < items.size() && ((next = items.get(i)) == null || ((cont = next.func_77973_b().getContainerItem(next)) == null || cont.func_77973_b() == next.func_77973_b()) && (cont = FluidContainerRegistry.drainFluidContainer((ItemStack)next)) == null); ++i) {
            }
            return cont == null ? null : cont;
        }

        @Override
        public boolean isFoodRecipe() {
            return this.foodRecipe;
        }

        @Override
        public boolean forceReturnContainer() {
            return this.forceContainer;
        }

        @Override
        public List<Object> getProcessedInput() {
            return new ArrayList<Object>(this.processedInput);
        }

        @Override
        @Deprecated
        public List<Object> getProsessedInput() {
            return new ArrayList<Object>(this.processedInput);
        }

        @Override
        public int getRecipeSize() {
            return this.processedInput.size();
        }

        @Override
        public boolean matches(List<ItemStack> items) {
            ArrayList<Object> required = new ArrayList<Object>(this.processedInput);
            boolean food = this.isFoodRecipe();
            for (int x = 0; x < items.size(); ++x) {
                ItemStack slot = items.get(x);
                if (slot == null) continue;
                boolean inRecipe = false;
                Iterator<Object> req = required.iterator();
                if (slot.func_77973_b() == DCsAppleMilk.slotPanel) {
                    inRecipe = true;
                    continue;
                }
                while (req.hasNext()) {
                    boolean match = false;
                    Object next = req.next();
                    if (next instanceof ItemStack) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                    } else if (next instanceof ArrayList) {
                        Iterator itr = ((ArrayList)next).iterator();
                        while (itr.hasNext() && !match) {
                            match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                        }
                    }
                    if (!match) continue;
                    inRecipe = true;
                    required.remove(next);
                    break;
                }
                if (inRecipe) continue;
                return false;
            }
            return required.isEmpty();
        }
    }
}

