/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mods.defeatedcrow.api.appliance.SoupType;
import mods.defeatedcrow.api.recipe.IFondueRecipe;
import mods.defeatedcrow.api.recipe.IFondueRegister;
import mods.defeatedcrow.api.recipe.IFondueSource;
import mods.defeatedcrow.common.AMTLogger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class FondueRecipeRegister
implements IFondueRegister {
    private List<FondueRecipe> recipes = new ArrayList<FondueRecipe>();
    private List<FondueSource> sources = new ArrayList<FondueSource>();

    @Override
    public void register(ItemStack input, ItemStack output, SoupType type) {
        if (output != null && input != null && type != null) {
            this.recipes.add(new FondueRecipe(input, output, type));
            AMTLogger.debugInfo("Add Fondue recipe: output " + output.func_82833_r());
        }
    }

    @Override
    public void registerByOre(String input, ItemStack output, SoupType type) {
        if (output != null && input != null && type != null) {
            this.recipes.add(new FondueRecipe(input, output, type));
            AMTLogger.debugInfo("Add Fondue recipe: output " + output.func_82833_r());
        }
    }

    @Override
    public void registerSource(Object input, SoupType before, SoupType result) {
        if (result != null && input != null && before != null) {
            this.sources.add(new FondueSource(input, before, result));
            AMTLogger.debugInfo("Add Fondue source: result " + result.display);
        }
    }

    @Override
    public List<? extends IFondueRecipe> getRecipeList() {
        return this.recipes;
    }

    @Override
    public List<? extends IFondueSource> getSourceList() {
        return this.sources;
    }

    @Override
    public IFondueRecipe getRecipe(ItemStack input, SoupType type) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        for (IFondueRecipe iFondueRecipe : this.recipes) {
            if (!iFondueRecipe.matches(input) || iFondueRecipe.getType() != type) continue;
            return iFondueRecipe;
        }
        return null;
    }

    @Override
    public IFondueSource getType(ItemStack input) {
        if (this.sources.isEmpty()) {
            return null;
        }
        for (IFondueSource iFondueSource : this.sources) {
            if (!iFondueSource.matches(input)) continue;
            return iFondueSource;
        }
        return null;
    }

    public class FondueSource
    implements IFondueSource {
        private final Object input;
        private final SoupType result;
        private final SoupType before;
        private ArrayList<ItemStack> processedInput;

        public FondueSource(Object in, SoupType bef, SoupType ret) {
            this.input = in;
            this.result = ret;
            this.before = bef;
            this.processedInput = new ArrayList();
            if (this.input instanceof String) {
                this.processedInput.addAll(OreDictionary.getOres((String)((String)this.input)));
            } else if (this.input instanceof ItemStack) {
                this.processedInput.add(((ItemStack)this.input).func_77946_l());
            } else if (this.input instanceof Item) {
                this.processedInput.add(new ItemStack((Item)this.input, 1, 0));
            } else if (this.input instanceof Block) {
                this.processedInput.add(new ItemStack((Block)this.input, 1, 0));
            } else {
                throw new IllegalArgumentException("Unknown Object passed to recipe!");
            }
        }

        @Override
        public Object getInput() {
            return this.input;
        }

        @Override
        public ArrayList<ItemStack> getProcessedInput() {
            return this.processedInput;
        }

        @Override
        public SoupType beforeType() {
            return this.before;
        }

        @Override
        public SoupType afterType() {
            return this.result;
        }

        @Override
        public boolean matches(ItemStack item) {
            ArrayList<ItemStack> required = new ArrayList<ItemStack>(this.processedInput);
            if (item != null && item.func_77973_b() != null && !required.isEmpty()) {
                Iterator<ItemStack> itr = required.iterator();
                boolean match = false;
                while (itr.hasNext() && !match) {
                    match = OreDictionary.itemMatches((ItemStack)itr.next(), (ItemStack)item, (boolean)false);
                }
                return match;
            }
            return false;
        }
    }

    public class FondueRecipe
    implements IFondueRecipe {
        private final Object input;
        private final ItemStack output;
        private SoupType type;
        private ArrayList<ItemStack> processedInput;

        public FondueRecipe(Object in, ItemStack out, SoupType t) {
            this.input = in;
            this.output = out;
            this.type = t;
            this.processedInput = new ArrayList();
            if (this.input instanceof String) {
                this.processedInput.addAll(OreDictionary.getOres((String)((String)this.input)));
            } else if (this.input instanceof ItemStack) {
                this.processedInput.add(((ItemStack)this.input).func_77946_l());
            } else if (this.input instanceof Item) {
                this.processedInput.add(new ItemStack((Item)this.input, 1, 0));
            } else if (this.input instanceof Block) {
                this.processedInput.add(new ItemStack((Block)this.input, 1, 0));
            } else {
                throw new IllegalArgumentException("Unknown Object passed to recipe!");
            }
        }

        @Override
        public Object getInput() {
            return this.input;
        }

        @Override
        public ArrayList<ItemStack> getProcessedInput() {
            return this.processedInput;
        }

        @Override
        public ItemStack getOutput() {
            return this.output == null ? null : this.output.func_77946_l();
        }

        @Override
        public SoupType getType() {
            return this.type;
        }

        @Override
        public boolean matches(ItemStack item) {
            ArrayList<ItemStack> required = new ArrayList<ItemStack>(this.processedInput);
            if (item != null && item.func_77973_b() != null && !required.isEmpty()) {
                Iterator<ItemStack> itr = required.iterator();
                boolean match = false;
                while (itr.hasNext() && !match) {
                    match = OreDictionary.itemMatches((ItemStack)itr.next(), (ItemStack)item, (boolean)false);
                }
                return match;
            }
            return false;
        }
    }
}

