/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.plugin.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.defeatedcrow.api.recipe.ICookingHeatSource;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.plugin.nei.GuiRecipe;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class HeatSourceHandler
extends TemplateRecipeHandler {
    private List<ICookingHeatSource> sources;

    private List<ICookingHeatSource> recipeLoader() {
        this.sources = new ArrayList<ICookingHeatSource>();
        ArrayList<ICookingHeatSource> list = new ArrayList<ICookingHeatSource>();
        if (RecipeRegisterManager.plateRecipe.getHeatSourcesList() != null && !RecipeRegisterManager.plateRecipe.getHeatSourcesList().isEmpty()) {
            list.addAll(RecipeRegisterManager.plateRecipe.getHeatSourcesList());
        }
        if (RecipeRegisterManager.panRecipe.getHeatSourcesList() != null && !RecipeRegisterManager.panRecipe.getHeatSourcesList().isEmpty()) {
            list.addAll(RecipeRegisterManager.panRecipe.getHeatSourcesList());
        }
        if (!list.isEmpty()) {
            for (ICookingHeatSource c : list) {
                boolean b = true;
                for (ICookingHeatSource t : this.sources) {
                    if (t.getBlock() == null || t.getBlock() != c.getBlock() || t.getMetadata() != c.getMetadata()) continue;
                    b = false;
                }
                if (!b) continue;
                this.sources.add(c);
            }
        }
        return this.sources;
    }

    public PositionedStack getResult() {
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiRecipe.class;
    }

    public String getOverlayIdentifier() {
        return "DCsHeatSource";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 27, 20, 10), "DCsHeatSource", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("DCsHeatSource") && ((Object)((Object)this)).getClass() == HeatSourceHandler.class) {
            List<ICookingHeatSource> recipes = this.recipeLoader();
            if (recipes == null || recipes.isEmpty()) {
                return;
            }
            for (ICookingHeatSource recipe : recipes) {
                Block block = recipe.getBlock();
                int m = recipe.getMetadata();
                boolean a = RecipeRegisterManager.plateRecipe.isHeatSource(block, m);
                boolean b = RecipeRegisterManager.panRecipe.isHeatSource(block, m);
                this.arecipes.add(new HeatRecipeCacher(new ItemStack(block, 1, m), a, b));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<ICookingHeatSource> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        for (ICookingHeatSource recipe : recipes) {
            Block block = recipe.getBlock();
            int m = recipe.getMetadata();
            ItemStack item = new ItemStack(block, 1, m);
            boolean a = RecipeRegisterManager.plateRecipe.isHeatSource(block, m);
            boolean b = RecipeRegisterManager.panRecipe.isHeatSource(block, m);
            if (ingredient.func_77973_b() == item.func_77973_b() && ingredient.func_77960_j() == item.func_77960_j()) {
                this.arecipes.add(new HeatRecipeCacher(ingredient, a, b));
                continue;
            }
            if (ingredient.func_77973_b() == Item.func_150898_a((Block)DCsAppleMilk.teppanII)) {
                this.arecipes.add(new HeatRecipeCacher(item, a, b));
                continue;
            }
            if (ingredient.func_77973_b() != Item.func_150898_a((Block)DCsAppleMilk.emptyPanGaiden)) continue;
            this.arecipes.add(new HeatRecipeCacher(item, a, b));
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"dc.HeatSourceGuiNEI");
    }

    public String getGuiTexture() {
        return "defeatedcrow:textures/gui/dummygui_2.png";
    }

    public class HeatRecipeCacher
    extends TemplateRecipeHandler.CachedRecipe {
        private PositionedStack input;
        private PositionedStack result1;
        private PositionedStack result2;
        private final ItemStack panItem;
        private final ItemStack plateItem;

        public HeatRecipeCacher(ItemStack in, boolean plate, boolean pan) {
            super((TemplateRecipeHandler)HeatSourceHandler.this);
            this.panItem = new ItemStack(DCsAppleMilk.emptyPanGaiden);
            this.plateItem = new ItemStack(DCsAppleMilk.teppanII);
            in.field_77994_a = 1;
            this.input = new PositionedStack((Object)in, 75, 37);
            if (pan) {
                if (plate) {
                    this.result1 = new PositionedStack((Object)this.panItem, 65, 12);
                    this.result2 = new PositionedStack((Object)this.plateItem, 85, 12);
                } else {
                    this.result1 = new PositionedStack((Object)this.panItem, 75, 12);
                    this.result2 = null;
                }
            } else if (plate) {
                this.result1 = new PositionedStack((Object)this.plateItem, 75, 12);
                this.result2 = null;
            } else {
                this.result1 = null;
                this.result2 = null;
            }
        }

        public PositionedStack getResult() {
            return this.result1;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getOtherStack() {
            return this.result2;
        }
    }
}

