/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.plugin.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.List;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.client.gui.GuiEvaporator;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.recipe.EvaporatorRecipeRegister;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class EvaporatorRecipeHandler
extends TemplateRecipeHandler {
    private List<EvaporatorRecipeRegister.EvaporatorRecipe> recipes;

    private List<EvaporatorRecipeRegister.EvaporatorRecipe> recipeLoader() {
        if (RecipeRegisterManager.evaporatorRecipe.getRecipeList() != null && !RecipeRegisterManager.evaporatorRecipe.getRecipeList().isEmpty()) {
            this.recipes = RecipeRegisterManager.evaporatorRecipe.getRecipeList();
        }
        return this.recipes;
    }

    public PositionedStack getResult() {
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiEvaporator.class;
    }

    public String getOverlayIdentifier() {
        return "DCsEvaporator";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(80, 15, 20, 20), "DCsEvaporator", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("DCsEvaporator") && ((Object)((Object)this)).getClass() == EvaporatorRecipeHandler.class) {
            List<EvaporatorRecipeRegister.EvaporatorRecipe> recipes = this.recipeLoader();
            if (recipes == null || recipes.isEmpty()) {
                return;
            }
            for (EvaporatorRecipeRegister.EvaporatorRecipe recipe : this.recipes) {
                ItemStack items = recipe.getOutput();
                ItemStack in = recipe.getInput();
                FluidStack f = recipe.getSecondary();
                this.arecipes.add(new EvaporatorRecipeCacher(in, items, null, f));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<EvaporatorRecipeRegister.EvaporatorRecipe> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        for (EvaporatorRecipeRegister.EvaporatorRecipe recipe : this.recipes) {
            NBTTagCompound tag;
            ItemStack items = recipe.getOutput();
            ItemStack in = recipe.getInput();
            FluidStack f = recipe.getSecondary();
            boolean flag = false;
            if (f != null && result.func_77973_b() == DCsAppleMilk.dummyItem && (tag = result.func_77978_p()) != null && tag.func_74764_b("fluid")) {
                String id = tag.func_74779_i("fluid");
                String name = f.getFluid().getLocalizedName(f);
                flag = id.equalsIgnoreCase(name);
            }
            if (!NEIServerUtils.areStacksSameType((ItemStack)items, (ItemStack)result) && !flag) continue;
            this.arecipes.add(new EvaporatorRecipeCacher(in, items, null, f));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<EvaporatorRecipeRegister.EvaporatorRecipe> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        for (EvaporatorRecipeRegister.EvaporatorRecipe recipe : this.recipes) {
            ItemStack items = recipe.getOutput();
            ItemStack in = recipe.getInput();
            FluidStack f = recipe.getSecondary();
            if (ingredient.func_77973_b() != in.func_77973_b() || ingredient.func_77960_j() != in.func_77960_j()) continue;
            this.arecipes.add(new EvaporatorRecipeCacher(in, items, null, f));
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"dc.EvaporatorNEI");
    }

    public String getGuiTexture() {
        return "defeatedcrow:textures/gui/evaporatorgui_nei.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(72, 7, 176, 0, 24, 16, 50, 0);
        this.drawProgressBar(52, 26, 201, 0, 15, 16, 50, 1);
        List<EvaporatorRecipeRegister.EvaporatorRecipe> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        if (this.arecipes.get(recipe) instanceof EvaporatorRecipeCacher) {
            EvaporatorRecipeCacher current = (EvaporatorRecipeCacher)((Object)this.arecipes.get(recipe));
            FluidStack get = current.fluid;
            this.drawFluid(get, 16, 106, 37, 16, 16);
        }
    }

    private void drawFluid(FluidStack fluid, int level, int x, int y, int width, int height) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        ResourceLocation res = null;
        res = fluid.getFluid().getSpriteNumber() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
        IIcon icon = fluid.getFluid().getIcon(fluid);
        if (icon == null) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        EvaporatorRecipeHandler.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int widR = width;
        int heiR = level;
        int yR = y + (height - heiR);
        int widL = 0;
        int heiL = 0;
        for (int i = 0; i < widR; i += 16) {
            for (int j = 0; j < heiR; j += 16) {
                widL = Math.min(widR - i, 16);
                heiL = Math.min(heiR - j, 16);
                this.drawTexturedModelRectFromIcon(x + i, yR + j, icon, widL, heiL);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public void drawTexturedModelRectFromIcon(int x, int y, IIcon icon, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public class EvaporatorRecipeCacher
    extends TemplateRecipeHandler.CachedRecipe {
        private PositionedStack input;
        private PositionedStack result;
        private PositionedStack leave;
        private PositionedStack dummy;
        private FluidStack fluid;

        public EvaporatorRecipeCacher(ItemStack in, ItemStack out, ItemStack sec, FluidStack f) {
            super((TemplateRecipeHandler)EvaporatorRecipeHandler.this);
            this.fluid = null;
            this.input = new PositionedStack((Object)in, 51, 6);
            if (out != null) {
                this.result = new PositionedStack((Object)out, 106, 10);
            }
            if (sec != null) {
                this.leave = new PositionedStack((Object)in, 51, 24);
            }
            if (f != null) {
                this.fluid = f;
                ItemStack dummyForFluid = new ItemStack(DCsAppleMilk.dummyItem, 1, 0);
                String name = f.getFluid().getLocalizedName(f);
                short amount = (short)f.amount;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("fluid", name);
                tag.func_74777_a("amount", amount);
                dummyForFluid.func_77982_d(tag);
                this.dummy = new PositionedStack((Object)dummyForFluid, 106, 37);
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getOtherStack() {
            return this.dummy;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }
    }
}

