/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.plugin.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.handler.FluidContMap;
import mods.defeatedcrow.plugin.nei.GuiRecipe;
import mods.defeatedcrow.recipe.BrewingRecipe;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    private HashMap<Fluid, Fluid> recipes = new HashMap();

    private HashMap<Fluid, Fluid> recipeLoader() {
        if (!BrewingRecipe.recipe.isEmpty()) {
            for (Map.Entry<Fluid, Fluid> entry : BrewingRecipe.recipe.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                this.recipes.put(entry.getKey(), entry.getValue());
            }
        }
        return this.recipes;
    }

    public PositionedStack getResult() {
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiRecipe.class;
    }

    public String getOverlayIdentifier() {
        return "DCsBrewing";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(77, 33, 20, 20), "DCsBrewing", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("DCsBrewing") && ((Object)((Object)this)).getClass() == BrewingRecipeHandler.class) {
            HashMap<Fluid, Fluid> recipes = this.recipeLoader();
            if (recipes == null || recipes.isEmpty()) {
                return;
            }
            for (Map.Entry entry : recipes.entrySet()) {
                Fluid in = (Fluid)entry.getKey();
                Fluid out = (Fluid)entry.getValue();
                if (in == null || out == null) continue;
                ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
                FluidContMap.BottlePack pack = FluidContMap.getPack(in);
                if (pack != null && !pack.getAllContainer().isEmpty()) {
                    containers.addAll(pack.getAllContainer());
                }
                this.arecipes.add(new BrewRecipeCacher(containers, in, out));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<Fluid, Fluid> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty() || result == null) {
            return;
        }
        for (Map.Entry entry : recipes.entrySet()) {
            NBTTagCompound tag;
            Fluid in = (Fluid)entry.getKey();
            Fluid out = (Fluid)entry.getValue();
            boolean flag = this.contain(out, result);
            if (!flag && result.func_77973_b() == DCsAppleMilk.dummyItem && (tag = result.func_77978_p()) != null && tag.func_74764_b("fluid")) {
                String id = tag.func_74779_i("fluid");
                String name = out.getLocalizedName(new FluidStack(out, 100));
                flag = id.equalsIgnoreCase(name);
            }
            if (!flag || in == null || out == null) continue;
            ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
            FluidContMap.BottlePack pack = FluidContMap.getPack(in);
            if (pack == null || pack.getAllContainer().isEmpty()) continue;
            containers.addAll(pack.getAllContainer());
            this.arecipes.add(new BrewRecipeCacher(containers, in, out));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        HashMap<Fluid, Fluid> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty() || ingredient == null) {
            return;
        }
        for (Map.Entry entry : recipes.entrySet()) {
            FluidContMap.BottlePack pack;
            ArrayList<ItemStack> containers;
            NBTTagCompound tag;
            Fluid in = (Fluid)entry.getKey();
            Fluid out = (Fluid)entry.getValue();
            boolean flag = this.contain(in, ingredient);
            if (!flag && ingredient.func_77973_b() == DCsAppleMilk.dummyItem && (tag = ingredient.func_77978_p()) != null && tag.func_74764_b("fluid")) {
                String id = tag.func_74779_i("fluid");
                String name = in.getLocalizedName(new FluidStack(in, 100));
                flag = id.equalsIgnoreCase(name);
            }
            if (flag && in != null && out != null) {
                containers = new ArrayList<ItemStack>();
                pack = FluidContMap.getPack(in);
                if (pack == null || pack.getAllContainer().isEmpty()) continue;
                containers.addAll(pack.getAllContainer());
                this.arecipes.add(new BrewRecipeCacher(containers, in, out));
                continue;
            }
            if (in == null || ingredient.func_77973_b() != Item.func_150898_a((Block)DCsAppleMilk.barrel)) continue;
            containers = new ArrayList();
            pack = FluidContMap.getPack(in);
            if (pack != null && !pack.getAllContainer().isEmpty()) {
                containers.addAll(pack.getAllContainer());
                this.arecipes.add(new BrewRecipeCacher(containers, in, out));
            }
            this.arecipes.add(new BrewRecipeCacher(containers, in, out));
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"dc.BrewingGuiNEI");
    }

    public String getGuiTexture() {
        return "defeatedcrow:textures/gui/appliancegui_nei.png";
    }

    private boolean contain(Fluid in, ItemStack check) {
        boolean flag1 = false;
        if (check == null || in == null) {
            return false;
        }
        FluidStack target = new FluidStack(in, 100);
        flag1 = FluidContainerRegistry.containsFluid((ItemStack)check, (FluidStack)target);
        return flag1;
    }

    public void drawExtras(int recipe) {
        HashMap<Fluid, Fluid> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        if (this.arecipes.get(recipe) instanceof BrewRecipeCacher) {
            Minecraft mc = Minecraft.func_71410_x();
            this.drawAdditionalSlot(19, 7);
            String d = "4 days";
            mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)d, (Object[])new Object[0]), 95, 18, 0);
            String r = "Use by Right-Click";
            mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)r, (Object[])new Object[0]), 4, 32, 0);
            BrewRecipeCacher current = (BrewRecipeCacher)((Object)this.arecipes.get(recipe));
            FluidStack in = current.influid;
            FluidStack out = current.resfluid;
            this.drawFluid(in, 16, 20, 8, 16, 16);
            this.drawFluid(out, 16, 118, 33, 16, 16);
        }
    }

    private void drawAdditionalSlot(int x, int y) {
        ResourceLocation res = new ResourceLocation(this.getGuiTexture());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
        Minecraft.func_71410_x().field_71462_r.func_73729_b(x, y, 44, 18, 18, 18);
    }

    private void drawFluid(FluidStack fluid, int level, int x, int y, int width, int height) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        ResourceLocation res = null;
        res = fluid.getFluid().getSpriteNumber() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
        IIcon icon = fluid.getFluid().getIcon(fluid);
        if (icon == null) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BrewingRecipeHandler.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int widR = width;
        int heiR = level;
        int yR = y + (height - heiR);
        int widL = 0;
        int heiL = 0;
        for (int i = 0; i < widR; i += 16) {
            for (int j = 0; j < heiR; j += 16) {
                widL = Math.min(widR - i, 16);
                heiL = Math.min(heiR - j, 16);
                this.drawTexturedModelRectFromIcon(x + i, yR + j, icon, widL, heiL);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public void drawTexturedModelRectFromIcon(int x, int y, IIcon icon, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public class BrewRecipeCacher
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> inputList;
        public PositionedStack input;
        public PositionedStack result;
        public PositionedStack barrel;
        private FluidStack influid;
        private FluidStack resfluid;

        public BrewRecipeCacher() {
            super((TemplateRecipeHandler)BrewingRecipeHandler.this);
            this.influid = null;
            this.resfluid = null;
            this.inputList = new ArrayList();
        }

        public BrewRecipeCacher(List<ItemStack> input, Fluid in, Fluid out) {
            this();
            this.setInput(input);
            if (in != null) {
                this.influid = new FluidStack(in, 1000);
                ItemStack dummyForFluid = new ItemStack(DCsAppleMilk.dummyItem, 1, 0);
                String name = in.getLocalizedName(this.influid);
                short amount = 1000;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("fluid", name);
                tag.func_74777_a("amount", amount);
                dummyForFluid.func_77982_d(tag);
                this.input = new PositionedStack((Object)dummyForFluid, 20, 8);
            }
            if (out != null) {
                this.resfluid = new FluidStack(out, 1000);
                ItemStack dummyForFluid2 = new ItemStack(DCsAppleMilk.dummyItem, 1, 0);
                String name2 = out.getLocalizedName(this.resfluid);
                short amount2 = 1000;
                NBTTagCompound tag2 = new NBTTagCompound();
                tag2.func_74778_a("fluid", name2);
                tag2.func_74777_a("amount", amount2);
                dummyForFluid2.func_77982_d(tag2);
                this.result = new PositionedStack((Object)dummyForFluid2, 118, 33);
            }
            ItemStack item = new ItemStack(DCsAppleMilk.barrel, 1, 0);
            this.barrel = new PositionedStack((Object)item, 77, 33);
        }

        public void setInput(List<ItemStack> items) {
            this.inputList.clear();
            PositionedStack stack = new PositionedStack(items, 40, 8);
            stack.setMaxSize(1);
            this.inputList.add(stack);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(BrewingRecipeHandler.this.cycleticks / 20, this.inputList);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(this.input);
            stacks.add(this.barrel);
            return stacks;
        }

        public FluidStack getInFluid() {
            return this.influid;
        }

        public FluidStack getResFluid() {
            return this.resfluid;
        }
    }
}

