/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.plugin.ffm;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.vect.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.plugin.ffm.LoadForestryPlugin;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmLogicAMT
extends FarmLogic {
    private final IFarmable[] plants = LoadForestryPlugin.farmables;

    public FarmLogicAMT(IFarmHousing housing) {
        super(housing);
    }

    public IIcon getIcon() {
        return DCsAppleMilk.leafTea.func_77617_a(0);
    }

    public String getName() {
        if (this.isManual) {
            return "AMT Manual Plantation";
        }
        return "AMT Managed Plantation";
    }

    public int getFertilizerConsumption() {
        return 80;
    }

    public int getWaterConsumption(float hydrationModifier) {
        return (int)(10.0f * hydrationModifier);
    }

    public boolean isAcceptedResource(ItemStack itemstack) {
        if (this.isManual) {
            return false;
        }
        return itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    public boolean isAcceptedGermling(ItemStack itemstack) {
        if (this.isManual) {
            return false;
        }
        for (IFarmable farm : this.plants) {
            if (!farm.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    public Collection<ItemStack> collect() {
        return null;
    }

    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            if (!world.func_147437_c(x, y + 1, z) || world.func_147439_a(x, y, z) != Blocks.field_150346_d) continue;
            for (IFarmable plant : this.plants) {
                if (!this.housing.plantGermling(plant, world, x, y + 1, z)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            for (int j = 0; j < 2; ++j) {
                Vect position = this.translateWithOffset(x, y + 1 + j, z, direction, i);
                for (IFarmable seed : this.plants) {
                    ICrop crop = seed.getCropAt(world, position.x, position.y, position.z);
                    if (crop == null) continue;
                    crops.push(crop);
                }
            }
        }
        return crops;
    }
}

