/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class FluidContMap {
    public static final FluidContMap instance = new FluidContMap();
    private static List<BottlePack> bottleList = new ArrayList<BottlePack>();

    private FluidContMap() {
    }

    public static void Register(Fluid f, FluidContainerRegistry.FluidContainerData data) {
        if (f == null || data == null || data.filledContainer == null) {
            return;
        }
        boolean flag = true;
        BottlePack target = null;
        for (BottlePack b : bottleList) {
            if (b.getFluid() != f) continue;
            target = b;
        }
        if (target != null) {
            for (ItemStack item : target.getAllContainer()) {
                if (!FluidContMap.isSameItem(data.filledContainer, item)) continue;
                flag = false;
            }
            if (flag) {
                target.addList(data);
            }
        } else {
            FluidContMap fluidContMap = instance;
            fluidContMap.getClass();
            BottlePack pack = fluidContMap.new BottlePack(f, data);
            bottleList.add(pack);
        }
    }

    private static boolean isSameItem(ItemStack in, ItemStack tar) {
        if (in == null || tar == null) {
            return false;
        }
        if (in.func_77973_b() == tar.func_77973_b()) {
            int b;
            int a = in.func_77958_k();
            return a == (b = tar.func_77960_j()) || b == Short.MAX_VALUE;
        }
        return false;
    }

    public static BottlePack getPack(Fluid f) {
        if (bottleList.isEmpty()) {
            return null;
        }
        for (BottlePack b : bottleList) {
            if (b.getFluid() != f) continue;
            return b;
        }
        return null;
    }

    public class BottlePack {
        public final Fluid fluid;
        public final List<FluidContainerRegistry.FluidContainerData> dataList = new ArrayList<FluidContainerRegistry.FluidContainerData>();

        public BottlePack(Fluid f, FluidContainerRegistry.FluidContainerData d) {
            this.fluid = f;
            this.dataList.add(d);
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public List<FluidContainerRegistry.FluidContainerData> getList() {
            return this.dataList;
        }

        public boolean addList(FluidContainerRegistry.FluidContainerData data) {
            if (data != null && data.filledContainer != null) {
                return this.dataList.add(data);
            }
            return false;
        }

        public boolean isFilledContainer(ItemStack cont) {
            if (cont == null || cont.func_77973_b() == null || this.dataList.isEmpty()) {
                return false;
            }
            boolean flag = false;
            for (FluidContainerRegistry.FluidContainerData d : this.dataList) {
                if (!this.match(cont, d.filledContainer)) continue;
                flag = true;
            }
            return flag;
        }

        public List<ItemStack> getAllContainer() {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            if (!this.dataList.isEmpty()) {
                for (FluidContainerRegistry.FluidContainerData d : this.dataList) {
                    if (d.filledContainer == null) continue;
                    ret.add(d.filledContainer);
                }
            }
            return ret;
        }

        private boolean match(ItemStack a, ItemStack b) {
            if (a != null && b != null && a.func_77973_b() == b.func_77973_b()) {
                return a.func_77960_j() == b.func_77960_j() || b.func_77960_j() == Short.MAX_VALUE;
            }
            return false;
        }
    }
}

