/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile.energy;

import cofh.api.energy.IEnergyProvider;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import mods.defeatedcrow.api.charge.IChargeGenerator;
import mods.defeatedcrow.api.charge.IChargeableMachine;
import mods.defeatedcrow.common.config.PropertyHandler;
import mods.defeatedcrow.plugin.SSector.SS2DeviceHandler;
import mods.defeatedcrow.plugin.cofh.RFDeviceHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyProvider", modid="CoFHAPI|energy")})
public class TileHandleEngine
extends TileEntity
implements IChargeGenerator,
IEnergyProvider {
    private int interval = 0;
    private int round = 0;
    private int click = 0;
    private int chargeAmount = 0;
    private final int MAX_CHARGE = 32;
    private int lastRound = 0;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.interval = par1NBTTagCompound.func_74765_d("Interval");
        this.round = par1NBTTagCompound.func_74765_d("Round");
        this.click = par1NBTTagCompound.func_74765_d("Click");
        this.chargeAmount = par1NBTTagCompound.func_74765_d("ChargeAmount");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        par1NBTTagCompound.func_74777_a("Interval", (short)this.interval);
        par1NBTTagCompound.func_74777_a("Round", (short)this.round);
        par1NBTTagCompound.func_74777_a("Click", (short)this.click);
        par1NBTTagCompound.func_74777_a("ChargeAmount", (short)this.chargeAmount);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void setChargeAmount(int par1) {
        this.chargeAmount = par1;
    }

    public int getChargeAmount() {
        return this.chargeAmount;
    }

    public void setClick(int par1) {
        this.click = par1;
    }

    public int getClick() {
        return this.click;
    }

    public void setInterval(int par1) {
        if (par1 > 8) {
            par1 = 8;
        }
        this.interval = par1;
    }

    public float getRound() {
        return this.round;
    }

    private int rateRF() {
        return PropertyHandler.rateRF();
    }

    public void func_145845_h() {
        TileEntity tile;
        if (this.interval > 0) {
            int next = this.chargeAmount + 2;
            next = Math.min(next, 32);
            this.setChargeAmount(next);
            int r = this.round + 4;
            if (r > 360) {
                r -= 360;
            }
            this.round = r;
            --this.interval;
        }
        if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) != null) {
            int ext2;
            int ext = Math.min(this.chargeAmount, 2);
            boolean b = false;
            if (tile instanceof IChargeableMachine) {
                b = true;
            }
            if (!b && Loader.isModLoaded((String)"SextiarySector")) {
                ext2 = ext * PropertyHandler.rateGF();
                ext2 = SS2DeviceHandler.inputEnergy(tile, ForgeDirection.UP, ext2, true);
                if (SS2DeviceHandler.isGFDevice(tile) && ext2 > 0) {
                    SS2DeviceHandler.inputEnergy(tile, ForgeDirection.UP, ext2, false);
                    this.chargeAmount -= ext;
                    b = true;
                }
            }
            if (!b && ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy")) {
                ext2 = ext * PropertyHandler.rateRF();
                ext2 = RFDeviceHandler.inputEnergy(ForgeDirection.UP, tile, ext2, true);
                if (RFDeviceHandler.isRFDevice(tile) && ext2 > 0) {
                    RFDeviceHandler.inputEnergy(ForgeDirection.UP, tile, ext2, false);
                    this.chargeAmount -= ext;
                    boolean bl = true;
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateServer();
        }
    }

    public void updateServer() {
        int current = this.round;
        if (current != this.lastRound) {
            this.lastRound = current;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean canGenerate() {
        return this.chargeAmount > 0;
    }

    @Override
    public int generateCharge(ForgeDirection dir, boolean flag) {
        if (dir != ForgeDirection.DOWN) {
            return 0;
        }
        int ret = Math.min(this.chargeAmount, 2);
        if (ret > 0) {
            if (!flag) {
                this.chargeAmount -= ret;
            }
            return ret;
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection paramForgeDirection) {
        return paramForgeDirection == ForgeDirection.DOWN && this.chargeAmount > 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ForgeDirection paramForgeDirection, int paramInt, boolean paramBoolean) {
        if (paramForgeDirection != ForgeDirection.DOWN) {
            return 0;
        }
        int ret = Math.min(this.chargeAmount, 2);
        int extract = ret * PropertyHandler.rateRF();
        if (ret > 0) {
            this.chargeAmount -= ret;
            return extract;
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection paramForgeDirection) {
        return this.chargeAmount * PropertyHandler.rateRF();
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection paramForgeDirection) {
        return this.MAX_CHARGE * PropertyHandler.rateRF();
    }
}

