/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile.energy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.defeatedcrow.api.charge.ChargeItemManager;
import mods.defeatedcrow.api.charge.IChargeGenerator;
import mods.defeatedcrow.api.charge.IChargeItem;
import mods.defeatedcrow.api.charge.IChargeableMachine;
import mods.defeatedcrow.api.energy.IBattery;
import mods.defeatedcrow.common.config.DCsConfig;
import mods.defeatedcrow.handler.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class TileChargerBase
extends TileEntity
implements ISidedInventory,
IChargeableMachine {
    protected int chargeAmount = 0;
    private int coolTime = 4;
    public final int MAX_CHARGE = 128000;
    public ItemStack[] itemstacks = new ItemStack[this.func_70302_i_()];

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.itemstacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.itemstacks.length) continue;
            this.itemstacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.chargeAmount = par1NBTTagCompound.func_74762_e("ChargeAmount");
        this.coolTime = par1NBTTagCompound.func_74771_c("CoolTime");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.itemstacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        par1NBTTagCompound.func_74768_a("ChargeAmount", this.chargeAmount);
        par1NBTTagCompound.func_74774_a("CoolTime", (byte)this.coolTime);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        return this.chargeAmount * par1 / this.getMaxChargeAmount();
    }

    public boolean isFullCharged() {
        return this.chargeAmount == this.getMaxChargeAmount();
    }

    @Override
    public int getMaxChargeAmount() {
        return 128000;
    }

    public void setChargeAmount(int par1) {
        int ret;
        this.chargeAmount = ret = Math.min(par1, this.getMaxChargeAmount());
    }

    @Override
    public int getChargeAmount() {
        return this.chargeAmount;
    }

    public int getUpper() {
        int i = this.chargeAmount;
        int get = i >>> 4;
        return get;
    }

    public int getUnder() {
        int i = this.chargeAmount;
        int get = i & 0xF;
        return get;
    }

    public void setUpper(int i) {
        int current = this.chargeAmount & 0xF;
        int get = i << 4;
        get += current;
        this.chargeAmount = get = Math.min(get, 128000);
    }

    public void setUnder(int i) {
        int currentUpper = this.chargeAmount >>> 4;
        int cur = currentUpper << 4;
        int get = i & 0xF;
        get += cur;
        this.chargeAmount = get = Math.min(get, 128000);
    }

    public void func_145845_h() {
        boolean flag = this.isFullCharged();
        boolean flag1 = false;
        if (this.coolTime > 0) {
            --this.coolTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection[] dirs;
            if (this.coolTime == 0) {
                ItemStack retItem = null;
                if (!flag && this.isItemFuel(this.itemstacks[0])) {
                    int i = this.chargeAmount + this.getItemBurnTime(this.itemstacks[0]);
                    int j = this.getItemBurnTime(this.itemstacks[0]);
                    if (i <= this.getMaxChargeAmount()) {
                        if (this.itemstacks[0].func_77973_b() instanceof IBattery) {
                            IBattery bat = (IBattery)this.itemstacks[0].func_77973_b();
                            bat.discharge(this.itemstacks[0], 16, true);
                            this.chargeAmount = i;
                            flag1 = true;
                        } else if (this.batteryContainerItem(this.itemstacks[0]) != null) {
                            if (this.itemstacks[1] == null || this.itemstacks[1].func_77973_b() == this.batteryContainerItem(this.itemstacks[0]).func_77973_b() && this.itemstacks[1].func_77960_j() == this.batteryContainerItem(this.itemstacks[0]).func_77960_j() && this.itemstacks[1].field_77994_a < this.itemstacks[1].func_77976_d()) {
                                retItem = this.batteryContainerItem(this.itemstacks[0]);
                                this.chargeAmount = i;
                                flag1 = true;
                            }
                        } else {
                            int ret = this.discharge(this.itemstacks[0], j, 0);
                            if (ret > 0) {
                                this.chargeAmount += ret;
                                flag = true;
                            }
                        }
                    }
                }
                if (this.itemstacks[0] != null && this.itemstacks[0].func_77973_b() instanceof IBattery) {
                    IBattery bat = (IBattery)this.itemstacks[0].func_77973_b();
                    if (bat.getChargeAmount(this.itemstacks[0]) == 0 && this.itemstacks[1] == null) {
                        this.func_70299_a(1, this.itemstacks[0].func_77946_l());
                        this.func_70298_a(0, 1);
                    }
                } else if (retItem != null && flag1) {
                    if (this.itemstacks[1] == null) {
                        this.func_70299_a(1, retItem.func_77946_l());
                    } else {
                        ++this.itemstacks[1].field_77994_a;
                    }
                    this.func_70298_a(0, 1);
                }
                for (int i = 2; i < this.func_70302_i_(); ++i) {
                    ItemStack current = this.itemstacks[i];
                    int charge = this.getChargeAmount();
                    int inc = Math.min(charge, 16);
                    if (!Util.notEmptyItem(current) || inc <= 0) continue;
                    if (current.func_77973_b() instanceof IBattery) {
                        IBattery bat = (IBattery)current.func_77973_b();
                        int ret = bat.charge(current, inc, true);
                        this.setChargeAmount(charge - ret);
                        continue;
                    }
                    if (!this.isChargeableBattery(current)) continue;
                    int ret = this.chargeAnotherBattery(current, inc, false);
                    this.setChargeAmount(charge - ret);
                }
                this.coolTime = DCsConfig.batteryUpdate;
            }
            for (ForgeDirection dir : dirs = ForgeDirection.VALID_DIRECTIONS) {
                if (this.isFullCharged()) continue;
                int accept = this.acceptChargeFromDir(dir);
                int cap = this.getMaxChargeAmount() - this.getChargeAmount();
                accept = Math.min(accept, cap);
                this.chargeAmount += accept;
            }
            if (this.chargeAmount > this.getMaxChargeAmount()) {
                this.chargeAmount = this.getMaxChargeAmount();
            }
            if (this.getChargeAmount() < 1) {
                flag1 = true;
            }
            this.func_70296_d();
        }
    }

    @Override
    public boolean isActive() {
        return this.coolTime > 0;
    }

    @Override
    public boolean canReceiveChargeItem(ItemStack item) {
        ItemStack current;
        boolean flag = false;
        boolean flag2 = false;
        if (item != null) {
            int i = this.getItemBurnTime(item);
            boolean bl = flag = i > 0 && this.getChargeAmount() + i <= this.getMaxChargeAmount();
        }
        flag2 = this.func_70301_a(0) == null ? true : item.func_77969_a(current = this.func_70301_a(0)) && current.field_77994_a + item.field_77994_a < current.func_77976_d();
        return flag && flag2;
    }

    @Override
    public int addCharge(int amount, boolean isSimulate) {
        int eng = this.getChargeAmount();
        int get = amount;
        if (this.isFullCharged()) {
            return 0;
        }
        int ret = Math.min(this.getMaxChargeAmount() - eng, get);
        if (!isSimulate) {
            this.setChargeAmount(eng + ret);
        }
        return ret;
    }

    @Override
    public int extractCharge(int amount, boolean isSimulate) {
        int eng = this.getChargeAmount();
        int get = amount;
        int ret = Math.min(eng, get);
        if (!isSimulate) {
            this.setChargeAmount(eng - ret);
        }
        return ret;
    }

    public int getItemBurnTime(ItemStack par0ItemStack) {
        if (par0ItemStack == null) {
            return 0;
        }
        if (ChargeItemManager.chargeItem.getChargeAmount(par0ItemStack) > 0) {
            return ChargeItemManager.chargeItem.getChargeAmount(par0ItemStack);
        }
        if (par0ItemStack.func_77973_b() instanceof IBattery) {
            IBattery bat = (IBattery)par0ItemStack.func_77973_b();
            int ret = bat.discharge(par0ItemStack, 16, false);
            return ret;
        }
        return 0;
    }

    public boolean isItemFuel(ItemStack par0ItemStack) {
        return this.getItemBurnTime(par0ItemStack) > 0;
    }

    public int discharge(ItemStack item, int amount, int slot) {
        this.func_70298_a(slot, 1);
        return amount;
    }

    public int acceptChargeFromDir(ForgeDirection dir) {
        IChargeGenerator device;
        int get;
        ForgeDirection opposite = dir.getOpposite();
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (tile instanceof IChargeGenerator && (get = (device = (IChargeGenerator)tile).generateCharge(opposite, true)) > 0) {
            device.generateCharge(opposite, false);
            return get;
        }
        return 0;
    }

    public boolean isChargeableBattery(ItemStack item) {
        return false;
    }

    public int chargeAnotherBattery(ItemStack item, int inc, boolean isSimulate) {
        return 0;
    }

    public ItemStack batteryContainerItem(ItemStack item) {
        if (item != null && item.func_77973_b() != null) {
            if (item.func_77973_b() instanceof IChargeItem) {
                return ((IChargeItem)item.func_77973_b()).returnItem();
            }
            if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
                return FluidContainerRegistry.drainFluidContainer((ItemStack)item);
            }
            return item.func_77973_b().getContainerItem(item);
        }
        return null;
    }

    protected int[] slotsTop() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    protected int[] slotsBottom() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int par1) {
        return par1 < this.func_70302_i_() ? this.itemstacks[par1] : null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemstacks[par1] != null) {
            if (this.itemstacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemstacks[par1];
                this.itemstacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemstacks[par1].func_77979_a(par2);
            if (this.itemstacks[par1].field_77994_a == 0) {
                this.itemstacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemstacks[par1] != null) {
            ItemStack itemstack = this.itemstacks[par1];
            this.itemstacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 > this.func_70302_i_()) {
            par1 = 0;
        }
        this.itemstacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Battery Charger";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        if (par1 == 1) {
            return false;
        }
        if (par1 == 0) {
            return this.isItemFuel(par2ItemStack);
        }
        return par2ItemStack != null && par2ItemStack.func_77973_b() instanceof IBattery;
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? this.slotsBottom() : (par1 == 1 ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        if (par1 == 1) {
            return true;
        }
        if (par1 > 1) {
            if (par2ItemStack != null && par2ItemStack.func_77973_b() instanceof IBattery) {
                IBattery bat = (IBattery)par2ItemStack.func_77973_b();
                return bat.isFullCharged(par2ItemStack);
            }
            if (this.isChargeableBattery(par2ItemStack)) {
                return this.chargeAnotherBattery(par2ItemStack, 1, true) == 0;
            }
            return true;
        }
        return false;
    }
}

