/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.item.magic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.defeatedcrow.api.energy.IBattery;
import mods.defeatedcrow.common.AMTLogger;
import mods.defeatedcrow.common.entity.EntityAnchorMissile;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemFossilCannon
extends ItemBow
implements IBattery {
    public ItemFossilCannon() {
        this.func_77625_d(1);
        this.func_77656_e(16);
        this.setNoRepair();
    }

    @Override
    public int getMaxAmount(ItemStack item) {
        return 12800;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("defeatedcrow:purple_scale");
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        boolean ff = par3EntityPlayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)par1ItemStack) > 0;
        boolean flag2 = false;
        if (par1ItemStack.func_77973_b() == this) {
            int c2 = this.discharge(par1ItemStack, 400, false);
            if (ff || c2 == 400) {
                flag2 = true;
            }
        }
        if (flag2) {
            float yaw = par3EntityPlayer.field_70177_z;
            float pitch = par3EntityPlayer.field_70125_A;
            double dx = -((double)MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI))) * 30.0;
            double dz = (double)MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * 30.0;
            double dy = -((double)MathHelper.func_76126_a((float)(pitch / 180.0f * (float)Math.PI))) * 30.0;
            double minX = par3EntityPlayer.field_70165_t + Math.min(-1.0, dx);
            double minY = par3EntityPlayer.field_70163_u + Math.min(-1.0, dy);
            double minZ = par3EntityPlayer.field_70161_v + Math.min(-1.0, dz);
            double maxX = par3EntityPlayer.field_70165_t + Math.max(1.0, dx);
            double maxY = par3EntityPlayer.field_70163_u + Math.max(1.0, dy);
            double maxZ = par3EntityPlayer.field_70161_v + Math.max(1.0, dz);
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List list = par2World.func_72872_a(EntityLivingBase.class, aabb);
            EntityLivingBase target = null;
            AMTLogger.debugInfo("yaw & pitch : " + yaw + "," + pitch);
            AMTLogger.debugInfo("aabb : " + minX + "," + minY + "," + minZ + "," + maxX + "," + maxY + "," + maxZ);
            if (list != null && !list.isEmpty()) {
                for (int k = 0; k < list.size(); ++k) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(k);
                    if (!entity.func_70685_l((Entity)par3EntityPlayer) || entity instanceof EntityPlayer || entity instanceof EntityTameable || entity instanceof EntityHorse || entity instanceof EntityVillager) continue;
                    target = entity;
                    AMTLogger.debugInfo("target : " + target.toString());
                    break;
                }
            }
            int j = this.func_77626_a(par1ItemStack) - par4;
            float f = (float)j / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)par1ItemStack);
            int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)par1ItemStack);
            int fire = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)par1ItemStack);
            boolean flag = false;
            if (target != null) {
                EntityAnchorMissile bullet = new EntityAnchorMissile(par2World, (EntityLivingBase)par3EntityPlayer, target, 1.0f, 1.0f, par3EntityPlayer.field_70177_z, 0.0f, 0.0f, 0.0f);
                if (power > 0) {
                    bullet.setDamage(50.0 + (double)power * 5.0);
                }
                if (punch > 0) {
                    bullet.setKnockbackStrength(1 + punch);
                }
                if (fire > 0) {
                    bullet.func_70015_d(100);
                }
                ((IBattery)par1ItemStack.func_77973_b()).discharge(par1ItemStack, 400, true);
                par2World.func_72956_a((Entity)par3EntityPlayer, "random.pop", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!par2World.field_72995_K) {
                    flag = par2World.func_72838_d((Entity)bullet);
                }
            }
        }
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_94599_c(int par1) {
        return this.field_77791_bV;
    }

    @Override
    public int getChargeAmount(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null && nbt.func_74764_b("charge")) {
            int charge = nbt.func_74762_e("charge");
            return charge;
        }
        return 0;
    }

    @Override
    public boolean isFullCharged(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null && nbt.func_74764_b("charge")) {
            int charge = nbt.func_74762_e("charge");
            return charge >= this.getMaxAmount(item);
        }
        return false;
    }

    @Override
    public int charge(ItemStack item, int amount, boolean flag) {
        if (item == null) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int charge = 0;
        int increase = 0;
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        int i = this.getMaxAmount(item) - charge;
        Math.min(i, 0);
        increase = Math.min(amount, i);
        if (flag) {
            if (nbt != null) {
                nbt.func_74768_a("charge", charge + increase);
                item.func_77982_d(nbt);
            } else {
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("charge", charge + increase);
                item.func_77982_d(nbt2);
            }
        }
        return increase;
    }

    @Override
    public int discharge(ItemStack item, int amount, boolean flag) {
        if (item == null) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int charge = 0;
        int reduce = 0;
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        reduce = Math.min(amount, charge);
        if (flag) {
            if (nbt != null) {
                nbt.func_74768_a("charge", charge - reduce);
                item.func_77982_d(nbt);
            } else {
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("charge", charge - reduce);
                item.func_77982_d(nbt2);
            }
        }
        return reduce;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        int charge = 0;
        int max = this.getMaxAmount(par1ItemStack);
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        String s = new String("charge amount : " + charge + "/" + max);
        par3List.add(s);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        int charge = 0;
        int max = this.getMaxAmount(stack);
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
            charge = MathHelper.func_76125_a((int)charge, (int)0, (int)max);
        }
        int i = max - charge;
        return (double)i / (double)max;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

